/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import sim.display.GUIState;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimpleInspector;
import sim.util.Bag;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;

public abstract class FieldPortrayal {
    public Portrayal portrayalForAll;
    public Portrayal portrayalForNull;
    public Portrayal portrayalForNonNull;
    public Portrayal portrayalForRemainder;
    public WeakHashMap portrayals;
    public WeakHashMap classPortrayals;
    protected Object field = null;
    protected boolean immutableField = false;
    protected boolean dirtyField = true;

    public void setPortrayalForAll(Portrayal portrayal) {
        this.portrayalForAll = portrayal;
    }

    public Portrayal getPortrayalForAll() {
        return this.portrayalForAll;
    }

    public void setPortrayalForNull(Portrayal portrayal) {
        this.portrayalForNull = portrayal;
    }

    public Portrayal getPortrayalForNull() {
        return this.portrayalForNull;
    }

    public void setPortrayalForNonNull(Portrayal portrayal) {
        this.portrayalForNonNull = portrayal;
    }

    public Portrayal getPortrayalForNonNull() {
        return this.portrayalForNonNull;
    }

    public void setPortrayalForRemainder(Portrayal portrayal) {
        this.portrayalForRemainder = portrayal;
    }

    public Portrayal getPortrayalForRemainder() {
        return this.portrayalForRemainder;
    }

    public void setPortrayalForClass(Class cls, Portrayal portrayal) {
        if (this.classPortrayals == null) {
            this.classPortrayals = new WeakHashMap();
        }
        if (portrayal == null) {
            this.classPortrayals.remove(cls);
        } else {
            this.classPortrayals.put(cls, portrayal);
        }
    }

    public void setPortrayalForObject(Object obj, Portrayal portrayal) {
        if (this.portrayals == null) {
            this.portrayals = new WeakHashMap();
        }
        if (portrayal == null) {
            this.portrayals.remove(obj);
        } else {
            this.portrayals.put(obj, portrayal);
        }
    }

    public Portrayal getDefaultNullPortrayal() {
        return this.getDefaultPortrayal();
    }

    public abstract Portrayal getDefaultPortrayal();

    public Portrayal getPortrayalForObject(Object obj) {
        Portrayal tmp;
        if (this.portrayalForAll != null) {
            return this.portrayalForAll;
        }
        if (obj == null) {
            Portrayal tmp2;
            if (this.portrayalForNull != null) {
                return this.portrayalForNull;
            }
            if (this.portrayals != null && (tmp2 = (Portrayal)this.portrayals.get(obj)) != null) {
                return tmp2;
            }
            return this.getDefaultNullPortrayal();
        }
        if (obj instanceof Portrayal) {
            return (Portrayal)obj;
        }
        if (this.portrayalForNonNull != null) {
            return this.portrayalForNonNull;
        }
        if (this.portrayals != null && (tmp = (Portrayal)this.portrayals.get(obj)) != null) {
            return tmp;
        }
        if (this.classPortrayals != null && (tmp = (Portrayal)this.classPortrayals.get(obj.getClass())) != null) {
            return tmp;
        }
        if (this.portrayalForRemainder != null) {
            return this.portrayalForRemainder;
        }
        return this.getDefaultPortrayal();
    }

    public boolean isImmutableField() {
        return this.immutableField;
    }

    public void setImmutableField(boolean val) {
        this.immutableField = val;
        this.dirtyField = true;
    }

    public Object getField() {
        return this.field;
    }

    public abstract void setField(Object var1);

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        if (wrapper == null) {
            return null;
        }
        Inspector objectInspectorComponent = this.getPortrayalForObject(wrapper.getObject()).getInspector(wrapper, state);
        if (objectInspectorComponent == null) {
            return null;
        }
        return new CustomInspector(wrapper, objectInspectorComponent, state);
    }

    public String getName(LocationWrapper wrapper) {
        if (wrapper == null) {
            return "";
        }
        return this.getPortrayalForObject(wrapper.getObject()).getName(wrapper);
    }

    public String getStatus(LocationWrapper wrapper) {
        if (wrapper == null) {
            return "";
        }
        return this.getPortrayalForObject(wrapper.getObject()).getStatus(wrapper);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getPortrayalForObject(wrapper.getObject()).setSelected(wrapper, selected);
    }

    public void setSelected(Bag locationWrappers, boolean selected) {
        for (int x = 0; x < locationWrappers.numObjs; ++x) {
            LocationWrapper wrapper = (LocationWrapper)locationWrappers.objs[x];
            this.setSelected(wrapper, selected);
        }
    }

    public class CustomInspector
    extends Inspector {
        public JLabel positions = new JLabel();
        public DisclosurePanel disclosurePanel;
        public LabelledList fieldComponent = new LabelledList("Location");
        public Inspector locationInspector;
        public Inspector objectInspector;
        public LocationWrapper wrapper;
        public Object lastObject;
        public Object lastLocation;
        public GUIState state;

        public CustomInspector(LocationWrapper wrapper, Inspector objectInspector, GUIState state) {
            this.state = state;
            this.wrapper = wrapper;
            this.objectInspector = objectInspector;
            this.state = state;
            this.lastObject = wrapper.getObject();
            this.setLayout(new BorderLayout());
            this.lastLocation = wrapper.getLocation();
            this.positions.setText(wrapper.getLocationName());
            this.locationInspector = new SimpleInspector(this.lastLocation, state, null);
            this.disclosurePanel = new DisclosurePanel(this.positions, this.locationInspector, "Position");
            this.add((Component)this.disclosurePanel, "North");
            this.add((Component)objectInspector, "Center");
            this.updateInspector();
        }

        public String getTitle() {
            return this.objectInspector.getTitle();
        }

        public void updateInspector() {
            Object location;
            Object newObject = this.wrapper.getObject();
            if (newObject != this.lastObject) {
                this.remove(this.objectInspector);
                this.objectInspector = FieldPortrayal.this.getPortrayalForObject(this.wrapper.getObject()).getInspector(this.wrapper, this.state);
                this.add((Component)this.objectInspector, "Center");
                this.revalidate();
            }
            if ((location = this.wrapper.getLocation()) != this.lastLocation) {
                this.disclosurePanel.setDisclosedComponent(new SimpleInspector(location, this.state, null));
                this.lastLocation = location;
            }
            this.positions.setText(this.wrapper.getLocationName());
            this.objectInspector.updateInspector();
            this.locationInspector.updateInspector();
        }
    }
}

