/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import sim.display.Display2D;
import sim.engine.Schedule;
import sim.engine.SimState;
import sim.engine.Steppable;
import sim.engine.Stoppable;

public abstract class Inspector
extends JPanel {
    boolean _volatile = true;
    public static final ImageIcon INSPECT_ICON = Inspector.iconFor("Inspect.png");
    public static final ImageIcon INSPECT_ICON_P = Inspector.iconFor("InspectPressed.png");
    public static final ImageIcon UPDATE_ICON = Inspector.iconFor("Update.png");
    public static final ImageIcon UPDATE_ICON_P = Inspector.iconFor("UpdatePressed.png");

    public void setVolatile(boolean val) {
        this._volatile = val;
    }

    public boolean isVolatile() {
        return this._volatile;
    }

    public abstract void updateInspector();

    public String getTitle() {
        return "";
    }

    public Steppable getUpdateSteppable() {
        return new Steppable(){

            public void step(final SimState state) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Schedule schedule = state.schedule;
                        synchronized (schedule) {
                            Inspector.this.updateInspector();
                            Inspector.this.repaint();
                        }
                    }
                });
            }
        };
    }

    protected void updateButtonPressed() {
        this.updateInspector();
    }

    public Component makeUpdateButton() {
        JButton jb = new JButton(UPDATE_ICON);
        jb.setText("Refresh");
        jb.putClientProperty("Quaqua.Button.style", "square");
        jb.setToolTipText("Refreshes this inspector to reflect the current underlying values in the model.");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.updateButtonPressed();
            }
        });
        return jb;
    }

    static ImageIcon iconFor(String name) {
        return new ImageIcon(Inspector.class.getResource(name));
    }

    public Stoppable reviseStopper(Stoppable stopper) {
        return stopper;
    }

    public JFrame createFrame(final Stoppable stopper) {
        JScrollPane scroller = new JScrollPane(this);
        scroller.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JFrame frame = new JFrame(){

            public void dispose() {
                super.dispose();
                if (stopper != null) {
                    stopper.stop();
                }
            }
        };
        frame.setTitle(this.getTitle());
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)scroller, "Center");
        frame.setResizable(true);
        frame.pack();
        if (Display2D.isMacOSX) {
            Dimension d = frame.getSize();
            if (d.width < 128) {
                d.width = 128;
            }
            if (d.height < 37) {
                d.height = 37;
            }
            frame.setSize(d);
        }
        return frame;
    }
}

