/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.portrayal.inspector.PropertyInspector;
import sim.util.Interval;
import sim.util.Properties;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.gui.PropertyField;

public class SimpleInspector
extends Inspector {
    public static final int MAX_PROPERTIES = 25;
    public GUIState state;
    public Object object;
    public LabelledList propertyList;
    public Properties properties;
    public PropertyField[] members = new PropertyField[0];
    public String name;
    public int start = 0;
    public int count = 0;
    public JPanel header = new JPanel(){

        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }
    };
    public JLabel numElements = new JLabel();
    public Box startField = null;
    boolean fixedProperties = false;
    JButton updateButton = null;

    public SimpleInspector(Properties properties, GUIState state, String name) {
        this.setLayout(new BorderLayout());
        this.object = null;
        this.state = state;
        this.name = name;
        this.properties = properties;
        this.fixedProperties = true;
        this.header.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.generateProperties(0);
    }

    public SimpleInspector(Object object, GUIState state) {
        this(object, state, null);
    }

    public SimpleInspector(Object object, GUIState state, String name) {
        this.setLayout(new BorderLayout());
        this.object = object;
        this.state = state;
        this.name = name;
        this.header.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.generateProperties(0);
    }

    JPopupMenu makePreliminaryPopup(final int index) {
        Class type = this.properties.getType(index);
        if (this.properties.isComposite(index)) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menu = new JMenuItem("View");
            menu.setEnabled(true);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Properties props = SimpleInspector.this.properties;
                    SimpleInspector simpleInspector = new SimpleInspector(props.getValue(index), SimpleInspector.this.state);
                    Stoppable stopper = simpleInspector.reviseStopper(SimpleInspector.this.state.scheduleImmediateRepeat(true, simpleInspector.getUpdateSteppable()));
                    SimpleInspector.this.state.controller.registerInspector(simpleInspector, stopper);
                    JFrame frame = simpleInspector.createFrame(stopper);
                    frame.setVisible(true);
                }
            });
            popup.add(menu);
            return popup;
        }
        return null;
    }

    PropertyField makePropertyField(final int index) {
        Class type = this.properties.getType(index);
        return new PropertyField(null, this.properties.betterToString(this.properties.getValue(index)), this.properties.isReadWrite(index), this.properties.getDomain(index), this.properties.isComposite(index) ? 1 : (type == Boolean.TYPE || type == Boolean.class ? 0 : (this.properties.getDomain(index) == null ? 1 : (this.properties.getDomain(index) instanceof Interval ? 3 : 4)))){
            Properties props;
            {
                super(x0, x1, x2, x3, x4);
                this.props = SimpleInspector.this.properties;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String newValue(String newValue) {
                Schedule schedule = SimpleInspector.this.state.state.schedule;
                synchronized (schedule) {
                    if (this.props.setValue(index, newValue) == null) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (SimpleInspector.this.state.controller != null) {
                        SimpleInspector.this.state.controller.refresh();
                    }
                    return this.props.betterToString(this.props.getValue(index));
                }
            }
        };
    }

    void doEnsuredRepaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component != null) {
                    component.repaint();
                }
            }
        });
    }

    void generateProperties(int start) {
        if (!this.fixedProperties) {
            this.properties = Properties.getProperties(this.object, true, true, false, true);
        }
        final int len = this.properties.numProperties();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            return;
        }
        if (this.propertyList != null) {
            this.remove(this.propertyList);
        }
        this.propertyList = new LabelledList(this.name);
        if (len > 25) {
            String s = "Page forward/back through properties.  25 properties shown at a time.";
            if (this.startField == null) {
                NumberTextField f = new NumberTextField(" Go to ", start, 1.0, 25.0){

                    public double newValue(double newValue) {
                        int newIndex = (int)newValue;
                        if (newIndex < 0) {
                            newIndex = 0;
                        }
                        if (newIndex >= len) {
                            return (int)this.getValue();
                        }
                        SimpleInspector.this.generateProperties(newIndex);
                        return newIndex;
                    }
                };
                f.setToolTipText("Page forward/back through properties.  25 properties shown at a time.");
                this.numElements.setText(" of " + len + " ");
                this.numElements.setToolTipText("Page forward/back through properties.  25 properties shown at a time.");
                f.valField.setColumns(4);
                this.startField = new Box(0);
                this.startField.add(f);
                this.startField.add(this.numElements);
                this.startField.add(Box.createGlue());
                this.header.add((Component)this.startField, "Center");
            }
        } else {
            start = 0;
            if (this.startField != null) {
                this.header.remove(this.startField);
            }
        }
        this.members = new PropertyField[len];
        int end = start + 25;
        if (end > len) {
            end = len;
        }
        this.count = end - start;
        for (int i = start; i < end; ++i) {
            if (!this.properties.isHidden(i)) {
                this.members[i] = this.makePropertyField(i);
                this.propertyList.add(null, new JLabel(this.properties.getName(i) + " "), PropertyInspector.getPopupMenu(this.properties, i, this.state, this.makePreliminaryPopup(i)), this.members[i], null);
                continue;
            }
            this.members[i] = null;
        }
        this.add((Component)this.propertyList, "Center");
        this.start = start;
        this.revalidate();
    }

    public void setVolatile(boolean val) {
        super.setVolatile(val);
        if (this.isVolatile()) {
            if (this.updateButton != null) {
                this.header.remove(this.updateButton);
                this.revalidate();
            }
        } else if (this.updateButton == null) {
            this.updateButton = (JButton)this.makeUpdateButton();
            NumberTextField sacrificial = new NumberTextField(1.0, true);
            Dimension d = sacrificial.getPreferredSize();
            d.width = this.updateButton.getPreferredSize().width;
            this.updateButton.setPreferredSize(d);
            d = sacrificial.getMinimumSize();
            d.width = this.updateButton.getMinimumSize().width;
            this.updateButton.setMinimumSize(d);
            this.header.add((Component)this.updateButton, "West");
            this.revalidate();
        }
    }

    public void updateInspector() {
        if (this.properties.isVolatile()) {
            this.remove(this.propertyList);
            this.generateProperties(this.start);
            this.doEnsuredRepaint(this);
        } else {
            for (int i = this.start; i < this.start + this.count; ++i) {
                if (this.members[i] == null) continue;
                this.members[i].setValue(this.properties.betterToString(this.properties.getValue(i)));
            }
        }
    }

    public String getTitle() {
        return "" + this.object;
    }
}

