/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.continuous;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sim.field.continuous.Continuous2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.inspector.StableDouble2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Double2D;

public class ContinuousPortrayal2D
extends FieldPortrayal2D {
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    HashMap selectedWrappers = new HashMap();

    public void setField(Object field) {
        this.dirtyField = true;
        if (!(field instanceof Continuous2D)) {
            throw new RuntimeException("Invalid field for ContinuousPortrayal2D: " + field);
        }
        this.field = field;
    }

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public Double2D getLocation(DrawInfo2D info) {
        Continuous2D field = (Continuous2D)this.field;
        if (field == null) {
            return null;
        }
        double xScale = info.draw.width / field.width;
        double yScale = info.draw.height / field.height;
        double startx = (info.clip.x - info.draw.x) / xScale;
        double starty = (info.clip.y - info.draw.y) / yScale;
        return new Double2D(startx, starty);
    }

    public Point2D.Double getPositionInFieldPortrayal(Object object, DrawInfo2D fieldPortrayalInfo) {
        Continuous2D field = (Continuous2D)this.field;
        if (field == null) {
            return null;
        }
        double xScale = fieldPortrayalInfo.draw.width / field.width;
        double yScale = fieldPortrayalInfo.draw.height / field.height;
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), fieldPortrayalInfo.clip);
        Double2D loc = field.getObjectLocation(object);
        if (loc == null) {
            return null;
        }
        newinfo.draw.x = fieldPortrayalInfo.draw.x + xScale * loc.x;
        newinfo.draw.y = fieldPortrayalInfo.draw.y + yScale * loc.y;
        return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        Continuous2D field = (Continuous2D)this.field;
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        double xScale = info.draw.width / field.width;
        double yScale = info.draw.height / field.height;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        Bag objects = field.getAllObjects();
        double discretizationOverlap = field.discretization;
        for (int x = 0; x < objects.numObjs; ++x) {
            Double2D loc = field.getObjectLocation(objects.objs[x]);
            if (!(loc.x >= (double)startx - discretizationOverlap) || !(loc.x < (double)endx + discretizationOverlap) || !(loc.y >= (double)starty - discretizationOverlap) || !(loc.y < (double)endy + discretizationOverlap)) continue;
            Portrayal p = this.getPortrayalForObject(objects.objs[x]);
            if (!(p instanceof SimplePortrayal2D)) {
                throw new RuntimeException("Unexpected Portrayal " + p + " for object " + objects.objs[x] + " -- expected a SimplePortrayal2D");
            }
            SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
            newinfo.draw.x = info.draw.x + xScale * loc.x;
            newinfo.draw.y = info.draw.y + yScale * loc.y;
            Object portrayedObject = objects.objs[x];
            if (graphics == null) {
                if (!portrayal.hitObject(portrayedObject, newinfo)) continue;
                putInHere.add(this.getWrapper(portrayedObject));
                continue;
            }
            if (objectSelected && this.selectedWrappers.get(portrayedObject) != null) {
                LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(portrayedObject);
                portrayal.setSelected(wrapper, true);
                portrayal.draw(portrayedObject, graphics, newinfo);
                portrayal.setSelected(wrapper, false);
                continue;
            }
            portrayal.draw(portrayedObject, graphics, newinfo);
        }
    }

    public LocationWrapper getWrapper(Object obj) {
        Continuous2D field = (Continuous2D)this.field;
        final StableDouble2D w = new StableDouble2D(field, obj);
        return new LocationWrapper(obj, null, this){

            public Object getLocation() {
                w.update();
                return w;
            }

            public String getLocationName() {
                w.update();
                return w.toString();
            }
        };
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        if (selected) {
            boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
            this.getPortrayalForObject(obj).setSelected(wrapper, !selected);
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
        } else {
            this.selectedWrappers.remove(obj);
        }
        return true;
    }
}

