/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sim.display.Display2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.HexaValueGridPortrayal2D;
import sim.util.Bag;
import sim.util.MutableDouble;
import sim.util.gui.ColorMap;

public class FastHexaValueGridPortrayal2D
extends HexaValueGridPortrayal2D {
    BufferedImage buffer;
    WritableRaster raster;
    DataBufferInt dbuffer;
    final MutableDouble valueToPass = new MutableDouble(0.0);

    public FastHexaValueGridPortrayal2D(String valueName, boolean immutableField) {
        super(valueName);
        this.setImmutableField(immutableField);
    }

    public FastHexaValueGridPortrayal2D(String valueName) {
        this(valueName, false);
    }

    public FastHexaValueGridPortrayal2D(boolean immutableField) {
        this.setImmutableField(immutableField);
    }

    public FastHexaValueGridPortrayal2D() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        FastHexaValueGridPortrayal2D fastHexaValueGridPortrayal2D = this;
        synchronized (fastHexaValueGridPortrayal2D) {
            this.buffer = null;
        }
    }

    boolean shouldBuffer(Graphics2D graphics) {
        int buffering = this.getBuffering();
        if (buffering == 1) {
            return true;
        }
        if (buffering == 2) {
            return false;
        }
        if (Display2D.isMacOSX) {
            return graphics.getDeviceConfiguration().getDevice().getType() != 2;
        }
        if (Display2D.isWindows) {
            return this.immutableField && !this.dirtyField;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double scaleWidth = 1.5 * info.draw.width / (maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0);
        double translateWidth = info.draw.width / divideByX - scaleWidth / 2.0;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : (double[][])null;
        int[][] intField = isDoubleGrid2D ? (int[][])null : ((IntGrid2D)field).field;
        double yScale = info.draw.height / (double)(2 * maxY + 1);
        int startx = (int)((info.clip.x - translateWidth - info.draw.x) / scaleWidth);
        int starty = (int)((info.clip.y - info.draw.y) / (2.0 * yScale)) - 1;
        int endx = (int)((info.clip.x - translateWidth - info.draw.x + info.clip.width) / scaleWidth) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / (2.0 * yScale)) + 1;
        if (graphics != null && this.shouldBuffer(graphics)) {
            boolean newBuffer = false;
            FastHexaValueGridPortrayal2D fastHexaValueGridPortrayal2D = this;
            synchronized (fastHexaValueGridPortrayal2D) {
                if (this.buffer == null || this.buffer.getWidth() != maxX || this.buffer.getHeight() != 2 * maxY + 1) {
                    if (this.buffer != null) {
                        this.buffer.flush();
                    }
                    this.buffer = new BufferedImage(maxX, 2 * maxY + 1, 2);
                    newBuffer = true;
                    this.raster = this.buffer.getRaster();
                    this.dbuffer = (DataBufferInt)this.raster.getDataBuffer();
                }
            }
            DataBufferInt _dbuffer = this.dbuffer;
            if (newBuffer || !this.immutableField || this.dirtyField) {
                if (endx > maxX) {
                    endx = maxX;
                }
                if (endy > maxY) {
                    endy = maxY;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (starty < 0) {
                    starty = 0;
                }
                if (this.immutableField) {
                    startx = 0;
                    starty = 0;
                    endx = maxX;
                    endy = maxY;
                }
                int ex = endx;
                int ey = endy;
                int sx = startx;
                int sy = starty;
                ColorMap map = this.map;
                int scanlineStride = ((SinglePixelPackedSampleModel)this.raster.getSampleModel()).getScanlineStride();
                if (isDoubleGrid2D) {
                    for (int x = sx; x < ex; ++x) {
                        for (int y = sy; y < ey; ++y) {
                            int load;
                            if ((x & 1) == 0) {
                                load = map.getRGB(doubleField[x][y]);
                                _dbuffer.setElem(2 * y * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                                continue;
                            }
                            load = map.getRGB(doubleField[x][y]);
                            _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                            _dbuffer.setElem((2 * y + 2) * scanlineStride + x, load);
                        }
                    }
                } else {
                    for (int x = sx; x < ex; ++x) {
                        for (int y = sy; y < ey; ++y) {
                            int load;
                            if ((x & 1) == 0) {
                                load = map.getRGB(intField[x][y]);
                                _dbuffer.setElem(2 * y * scanlineStride + x, load);
                                _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                                continue;
                            }
                            load = map.getRGB(intField[x][y]);
                            _dbuffer.setElem((2 * y + 1) * scanlineStride + x, load);
                            _dbuffer.setElem((2 * y + 2) * scanlineStride + x, load);
                        }
                    }
                }
            }
            graphics.drawImage(this.buffer, (int)(info.draw.x + translateWidth), (int)info.draw.y, (int)((double)maxX * scaleWidth), (int)info.draw.height, null);
        } else {
            this.buffer = null;
            if (endx > maxX) {
                endx = maxX;
            }
            if (endy > maxY) {
                endy = maxY;
            }
            if (startx < 0) {
                startx = 0;
            }
            if (starty < 0) {
                starty = 0;
            }
            int ex = endx;
            int ey = endy;
            int sx = startx;
            int sy = starty;
            int _x = 0;
            int _y = 0;
            int _width = 0;
            int _height = 0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                for (int x = sx; x < ex; ++x) {
                    for (int y = sy; y < ey; ++y) {
                        Color c = map.getColor(doubleField[x][y]);
                        if (c.getAlpha() == 0) continue;
                        _x = (int)(translateWidth + infodrawx + scaleWidth * (double)x);
                        _y = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y : 2 * y + 1));
                        _width = (int)(translateWidth + infodrawx + scaleWidth * (double)(x + 1)) - _x;
                        _height = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y + 2 : 2 * y + 3)) - _y;
                        if (graphics != null) {
                            graphics.setColor(c);
                            graphics.fillRect(_x, _y, _width, _height);
                            continue;
                        }
                        if (!info.clip.intersects(_x, _y, _width, _height)) continue;
                        putInHere.add(this.getWrapper(doubleField[x][y], x, y));
                    }
                }
            } else {
                for (int x = sx; x < ex; ++x) {
                    for (int y = sy; y < ey; ++y) {
                        Color c = map.getColor(intField[x][y]);
                        if (c.getAlpha() == 0) continue;
                        _x = (int)(translateWidth + infodrawx + scaleWidth * (double)x);
                        _y = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y : 2 * y + 1));
                        _width = (int)(translateWidth + infodrawx + scaleWidth * (double)(x + 1)) - _x;
                        _height = (int)(infodrawy + yScale * (double)((x & 1) == 0 ? 2 * y + 2 : 2 * y + 3)) - _y;
                        if (graphics != null) {
                            graphics.setColor(c);
                            graphics.fillRect(_x, _y, _width, _height);
                            continue;
                        }
                        if (!info.clip.intersects(_x, _y, _width, _height)) continue;
                        putInHere.add(this.getWrapper(intField[x][y], x, y));
                    }
                }
            }
        }
        if (graphics != null) {
            this.dirtyField = false;
        }
    }
}

