/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import sim.display.Display2D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.util.gui.ColorMap;

public class FastValueGridPortrayal2D
extends ValueGridPortrayal2D {
    BufferedImage buffer;
    WritableRaster raster;
    int[] data = new int[0];

    public FastValueGridPortrayal2D(String valueName, boolean immutableField) {
        super(valueName);
        this.setImmutableField(immutableField);
    }

    public FastValueGridPortrayal2D(String valueName) {
        this(valueName, false);
    }

    public FastValueGridPortrayal2D(boolean immutableField) {
        this.setImmutableField(immutableField);
    }

    public FastValueGridPortrayal2D() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        FastValueGridPortrayal2D fastValueGridPortrayal2D = this;
        synchronized (fastValueGridPortrayal2D) {
            this.buffer = null;
        }
    }

    boolean shouldBuffer(Graphics2D graphics) {
        int buffering = this.getBuffering();
        if (buffering == 1) {
            return true;
        }
        if (buffering == 2) {
            return false;
        }
        if (Display2D.isMacOSX) {
            return graphics.getDeviceConfiguration().getDevice().getType() != 2;
        }
        if (Display2D.isWindows) {
            return this.immutableField && !this.dirtyField;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        int[][] intField;
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : (double[][])null;
        int[][] nArray = intField = isDoubleGrid2D ? (int[][])null : ((IntGrid2D)field).field;
        if (this.shouldBuffer(graphics)) {
            boolean newBuffer = false;
            FastValueGridPortrayal2D fastValueGridPortrayal2D = this;
            synchronized (fastValueGridPortrayal2D) {
                if (this.buffer == null || this.buffer.getWidth() != maxX || this.buffer.getHeight() != maxY) {
                    if (this.buffer != null) {
                        this.buffer.flush();
                    }
                    this.buffer = new BufferedImage(maxX, maxY, 2);
                    this.raster = this.buffer.getRaster();
                    newBuffer = true;
                }
            }
            if (newBuffer || !this.immutableField || this.dirtyField) {
                if (endx > maxX) {
                    endx = maxX;
                }
                if (endy > maxY) {
                    endy = maxY;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (starty < 0) {
                    starty = 0;
                }
                int ex = endx;
                int ey = endy;
                int sx = startx;
                int sy = starty;
                if (this.immutableField) {
                    startx = 0;
                    starty = 0;
                    endx = maxX;
                    endy = maxY;
                }
                ColorMap map = this.map;
                if (ex - sx > 0 && ey - sy > 0) {
                    int[] data = this.data;
                    if (data.length != (ex - sx) * (ey - sy)) {
                        data = this.data = new int[(ex - sx) * (ey - sy)];
                    }
                    int i = 0;
                    if (isDoubleGrid2D) {
                        for (int y = sy; y < ey; ++y) {
                            for (int x = sx; x < ex; ++x) {
                                data[i++] = map.getRGB(doubleField[x][y]);
                            }
                        }
                    } else {
                        for (int y = sy; y < ey; ++y) {
                            for (int x = sx; x < ex; ++x) {
                                data[i++] = map.getRGB(intField[x][y]);
                            }
                        }
                    }
                    this.raster.setDataElements(sx, sy, ex - sx, ey - sy, data);
                }
            }
            graphics.drawImage(this.buffer, (int)info.draw.x, (int)info.draw.y, (int)info.draw.width, (int)info.draw.height, null);
        } else {
            this.buffer = null;
            if (endx > maxX) {
                endx = maxX;
            }
            if (endy > maxY) {
                endy = maxY;
            }
            if (startx < 0) {
                startx = 0;
            }
            if (starty < 0) {
                starty = 0;
            }
            int ex = endx;
            int ey = endy;
            int sx = startx;
            int sy = starty;
            int _x = 0;
            int _y = 0;
            int _width = 0;
            int _height = 0;
            ColorMap map = this.map;
            double infodrawx = info.draw.x;
            double infodrawy = info.draw.y;
            if (isDoubleGrid2D) {
                for (int x = sx; x < ex; ++x) {
                    for (int y = sy; y < ey; ++y) {
                        Color c = map.getColor(doubleField[x][y]);
                        if (c.getAlpha() == 0) continue;
                        graphics.setColor(c);
                        _x = (int)(infodrawx + xScale * (double)x);
                        _y = (int)(infodrawy + yScale * (double)y);
                        _width = (int)(infodrawx + xScale * (double)(x + 1)) - _x;
                        _height = (int)(infodrawy + yScale * (double)(y + 1)) - _y;
                        graphics.fillRect(_x, _y, _width, _height);
                    }
                }
            } else {
                for (int x = sx; x < ex; ++x) {
                    for (int y = sy; y < ey; ++y) {
                        Color c = map.getColor(intField[x][y]);
                        if (c.getAlpha() == 0) continue;
                        graphics.setColor(c);
                        _x = (int)(infodrawx + xScale * (double)x);
                        _y = (int)(infodrawy + yScale * (double)y);
                        _width = (int)(infodrawx + xScale * (double)(x + 1)) - _x;
                        _height = (int)(infodrawy + yScale * (double)(y + 1)) - _y;
                        graphics.fillRect(_x, _y, _width, _height);
                    }
                }
            }
        }
        if (graphics != null) {
            this.dirtyField = false;
        }
    }
}

