/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.grid.ValueGridPortrayal2D;
import sim.util.Bag;
import sim.util.MutableDouble;

public class HexaValueGridPortrayal2D
extends ValueGridPortrayal2D {
    int[] xPoints = new int[6];
    int[] yPoints = new int[6];
    double[] xyC = new double[2];
    double[] xyC_ul = new double[2];
    double[] xyC_up = new double[2];
    double[] xyC_ur = new double[2];
    final MutableDouble valueToPass = new MutableDouble(0.0);
    GeneralPath generalPath = new GeneralPath();

    public HexaValueGridPortrayal2D() {
    }

    public HexaValueGridPortrayal2D(String valueName) {
        super(valueName);
    }

    static final void getxyC(int x, int y, double xScale, double yScale, double tx, double ty, double[] xyC) {
        xyC[0] = tx + xScale * (1.5 * (double)x + 1.0);
        xyC[1] = ty + yScale * (1.0 + 2.0 * (double)y + (double)(x < 0 ? -x % 2 : x % 2));
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        int[][] intField;
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double divideByX = maxX % 2 == 0 ? 3.0 * (double)maxX / 2.0 + 0.5 : 3.0 * (double)maxX / 2.0 + 2.0;
        double divideByY = 1.0 + 2.0 * (double)maxY;
        double xScale = info.draw.width / divideByX;
        double yScale = info.draw.height / divideByY;
        int startx = (int)(((info.clip.x - info.draw.x) / xScale - 0.5) / 1.5) - 2;
        int starty = (int)((info.clip.y - info.draw.y) / (yScale * 2.0)) - 2;
        int endx = (int)(((info.clip.x - info.draw.x + info.clip.width) / xScale - 0.5) / 1.5) + 4;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / (yScale * 2.0)) + 4;
        boolean isDoubleGrid2D = field instanceof DoubleGrid2D;
        double[][] doubleField = isDoubleGrid2D ? ((DoubleGrid2D)field).field : (double[][])null;
        int[][] nArray = intField = isDoubleGrid2D ? (int[][])null : ((IntGrid2D)field).field;
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        for (int y = starty; y < endy; ++y) {
            for (int x = startx; x < endx; ++x) {
                double x0 = x;
                double y0 = y;
                double tx = info.draw.x;
                double ty = info.draw.y;
                double xyC_x = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_y = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.ulx(x, y);
                y0 = field.uly(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_ulx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_uly = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.upx(x, y);
                y0 = field.upy(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_upx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_upy = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                x0 = field.urx(x, y);
                y0 = field.ury(x, y);
                tx = info.draw.x;
                ty = info.draw.y;
                double xyC_urx = tx + xScale * (1.5 * x0 + 1.0);
                double xyC_ury = ty + yScale * (1.0 + 2.0 * y0 + (x0 < 0.0 ? -x0 % 2.0 : x0 % 2.0));
                this.xPoints[0] = (int)(xyC_urx - 0.5 * xScale);
                this.yPoints[0] = (int)(xyC_ury + yScale);
                this.xPoints[1] = (int)(xyC_upx + 0.5 * xScale);
                this.yPoints[1] = (int)(xyC_upy + yScale);
                this.xPoints[2] = (int)(xyC_upx - 0.5 * xScale);
                this.yPoints[2] = (int)(xyC_upy + yScale);
                this.xPoints[3] = (int)(xyC_ulx + 0.5 * xScale);
                this.yPoints[3] = (int)(xyC_uly + yScale);
                this.xPoints[4] = (int)(xyC_x - 0.5 * xScale);
                this.yPoints[4] = (int)(xyC_y + yScale);
                this.xPoints[5] = (int)(xyC_x + 0.5 * xScale);
                this.yPoints[5] = (int)(xyC_y + yScale);
                if (graphics == null) {
                    this.generalPath.reset();
                    this.generalPath.moveTo(this.xPoints[0], this.yPoints[0]);
                    for (int i = 1; i < 6; ++i) {
                        this.generalPath.lineTo(this.xPoints[i], this.yPoints[i]);
                    }
                    this.generalPath.closePath();
                    Area area = new Area(this.generalPath);
                    if (!area.intersects(info.clip.x, info.clip.y, info.clip.width, info.clip.height)) continue;
                    this.valueToPass.val = isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y];
                    putInHere.add(this.getWrapper(this.valueToPass.val, x, y));
                    continue;
                }
                Color c = this.map.getColor(isDoubleGrid2D ? doubleField[x][y] : (double)intField[x][y]);
                if (c.getAlpha() == 0) continue;
                graphics.setColor(c);
                graphics.fillPolygon(this.xPoints, this.yPoints, 6);
            }
        }
    }
}

