/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Int2D;
import sim.util.IntBag;

public class ObjectGridPortrayal2D
extends FieldPortrayal2D {
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    SimplePortrayal2D defaultNullPortrayal = new SimplePortrayal2D();
    final int SEARCH_DISTANCE = 3;
    IntBag xPos = new IntBag(49);
    IntBag yPos = new IntBag(49);
    final Message unknown = new Message("It's too costly to figure out where the object went.");
    LocationWrapper selectedWrapper = null;
    HashMap selectedWrappers = new HashMap();

    public void setField(Object field) {
        this.dirtyField = true;
        if (!(field instanceof ObjectGrid2D)) {
            throw new RuntimeException("Invalid field for ObjectGridPortrayal2D: " + field);
        }
        this.field = field;
    }

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public Portrayal getDefaultNullPortrayal() {
        return this.defaultNullPortrayal;
    }

    public Point2D.Double getPositionInFieldPortrayal(Object object, DrawInfo2D info) {
        ObjectGrid2D field = (ObjectGrid2D)this.field;
        if (field == null) {
            return null;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return null;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        for (int x = 0; x < maxX; ++x) {
            Object[] fieldx = field.field[x];
            for (int y = 0; y < maxY; ++y) {
                if (object != fieldx[y]) continue;
                newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
                newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
                newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
                newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
                newinfo.draw.x += newinfo.draw.width / 2.0;
                newinfo.draw.y += newinfo.draw.height / 2.0;
                return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
            }
        }
        return null;
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        ObjectGrid2D field = (ObjectGrid2D)this.field;
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        Object selectedObject = this.selectedWrapper == null ? null : this.selectedWrapper.getObject();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        if (maxX == 0 || maxY == 0) {
            return;
        }
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        if (endx > maxX) {
            endx = maxX;
        }
        if (endy > maxY) {
            endy = maxY;
        }
        if (startx < 0) {
            startx = 0;
        }
        if (starty < 0) {
            starty = 0;
        }
        for (int x = startx; x < endx; ++x) {
            for (int y = starty; y < endy; ++y) {
                Object obj = field.field[x][y];
                Portrayal p = this.getPortrayalForObject(obj);
                if (!(p instanceof SimplePortrayal2D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + obj + " -- expected a SimplePortrayal2D");
                }
                SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                newinfo.draw.x = (int)(info.draw.x + xScale * (double)x);
                newinfo.draw.y = (int)(info.draw.y + yScale * (double)y);
                newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(x + 1))) - newinfo.draw.x;
                newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(y + 1))) - newinfo.draw.y;
                newinfo.draw.x += newinfo.draw.width / 2.0;
                newinfo.draw.y += newinfo.draw.height / 2.0;
                if (graphics == null) {
                    if (obj == null || !portrayal.hitObject(obj, newinfo)) continue;
                    putInHere.add(this.getWrapper(obj, new Int2D(x, y)));
                    continue;
                }
                if (objectSelected && (selectedObject == obj || this.selectedWrappers.get(obj) != null)) {
                    LocationWrapper wrapper = null;
                    wrapper = selectedObject == obj ? this.selectedWrapper : (LocationWrapper)this.selectedWrappers.get(obj);
                    portrayal.setSelected(wrapper, true);
                    portrayal.draw(obj, graphics, newinfo);
                    portrayal.setSelected(wrapper, false);
                    continue;
                }
                portrayal.draw(obj, graphics, newinfo);
            }
        }
    }

    Int2D searchForObject(Object object, Int2D loc) {
        ObjectGrid2D field = (ObjectGrid2D)this.field;
        Object[][] grid = field.field;
        if (grid[loc.x][loc.y] == object) {
            return new Int2D(loc.x, loc.y);
        }
        field.getNeighborsMaxDistance(loc.x, loc.y, 3, true, this.xPos, this.yPos);
        for (int i = 0; i < this.xPos.numObjs; ++i) {
            if (grid[this.xPos.get(i)][this.yPos.get(i)] != object) continue;
            return new Int2D(this.xPos.get(i), this.yPos.get(i));
        }
        return null;
    }

    public LocationWrapper getWrapper(Object object, Int2D location) {
        final ObjectGrid2D field = (ObjectGrid2D)this.field;
        return new LocationWrapper(object, location, this){

            public Object getLocation() {
                Int2D loc = (Int2D)super.getLocation();
                if (field.field[loc.x][loc.y] == this.getObject()) {
                    return loc;
                }
                Int2D result = ObjectGridPortrayal2D.this.searchForObject(this.object, loc);
                if (result != null) {
                    this.location = result;
                    return result;
                }
                return ObjectGridPortrayal2D.this.unknown;
            }

            public String getLocationName() {
                Object loc = this.getLocation();
                if (loc instanceof Int2D) {
                    return ((Int2D)this.location).toCoordinates();
                }
                return "Location Unknown";
            }
        };
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        if (selected) {
            boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
            this.getPortrayalForObject(obj).setSelected(wrapper, !selected);
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
            this.selectedWrapper = wrapper;
        } else {
            this.selectedWrappers.remove(obj);
            this.selectedWrapper = null;
        }
        return true;
    }

    public static class Message {
        String message;

        public Message(String message) {
            this.message = message;
        }

        public String getSorry() {
            return this.message;
        }
    }
}

