/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.grid;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import sim.field.grid.Grid2D;
import sim.field.grid.SparseGrid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.grid.DrawPolicy;
import sim.portrayal.inspector.StableInt2D;
import sim.portrayal.simple.OvalPortrayal2D;
import sim.util.Bag;
import sim.util.Int2D;

public class SparseGridPortrayal2D
extends FieldPortrayal2D {
    public DrawPolicy policy;
    SimplePortrayal2D defaultPortrayal = new OvalPortrayal2D();
    HashMap selectedWrappers = new HashMap();

    public SparseGridPortrayal2D() {
    }

    public SparseGridPortrayal2D(DrawPolicy policy) {
        this.policy = policy;
    }

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public void setField(Object field) {
        this.dirtyField = true;
        if (!(field instanceof SparseGrid2D)) {
            throw new RuntimeException("Invalid field for Sparse2DPortrayal: " + field);
        }
        this.field = field;
    }

    public Int2D getLocation(DrawInfo2D info) {
        Grid2D field = (Grid2D)this.field;
        if (field == null) {
            return null;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        return new Int2D(startx, starty);
    }

    public Point2D.Double getPositionInFieldPortrayal(Object object, DrawInfo2D info) {
        SparseGrid2D field = (SparseGrid2D)this.field;
        if (field == null) {
            return null;
        }
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        Int2D loc = field.getObjectLocation(object);
        if (loc == null) {
            return null;
        }
        newinfo.draw.x = (int)(info.draw.x + xScale * (double)loc.x);
        newinfo.draw.y = (int)(info.draw.y + yScale * (double)loc.y);
        newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
        newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
        newinfo.draw.x += newinfo.draw.width / 2.0;
        newinfo.draw.y += newinfo.draw.height / 2.0;
        return new Point2D.Double(newinfo.draw.x, newinfo.draw.y);
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        SparseGrid2D field = (SparseGrid2D)this.field;
        if (field == null) {
            return;
        }
        boolean objectSelected = !this.selectedWrappers.isEmpty();
        int maxX = field.getWidth();
        int maxY = field.getHeight();
        double xScale = info.draw.width / (double)maxX;
        double yScale = info.draw.height / (double)maxY;
        int startx = (int)((info.clip.x - info.draw.x) / xScale);
        int starty = (int)((info.clip.y - info.draw.y) / yScale);
        int endx = (int)((info.clip.x - info.draw.x + info.clip.width) / xScale) + 1;
        int endy = (int)((info.clip.y - info.draw.y + info.clip.height) / yScale) + 1;
        Rectangle clip = graphics == null ? null : graphics.getClipBounds();
        DrawInfo2D newinfo = new DrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip);
        if (this.policy != null && graphics != null) {
            Bag policyBag = new Bag();
            Iterator iterator = field.locationBagIterator();
            while (iterator.hasNext()) {
                Bag objects = (Bag)iterator.next();
                if (objects == null) continue;
                policyBag.clear();
                if (this.policy.objectToDraw(objects, policyBag)) {
                    objects = policyBag;
                }
                for (int x = 0; x < objects.numObjs; ++x) {
                    Object portrayedObject = objects.objs[x];
                    Int2D loc = field.getObjectLocation(portrayedObject);
                    if (loc.x < startx - 2 || loc.x >= endx + 4 || loc.y < starty - 2 || loc.y >= endy + 4) continue;
                    Portrayal p = this.getPortrayalForObject(portrayedObject);
                    if (!(p instanceof SimplePortrayal2D)) {
                        throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                    }
                    SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                    newinfo.draw.x = (int)(info.draw.x + xScale * (double)loc.x);
                    newinfo.draw.y = (int)(info.draw.y + yScale * (double)loc.y);
                    newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
                    newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
                    newinfo.draw.x += newinfo.draw.width / 2.0;
                    newinfo.draw.y += newinfo.draw.height / 2.0;
                    if (objectSelected && this.selectedWrappers.get(portrayedObject) != null) {
                        LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(portrayedObject);
                        portrayal.setSelected(wrapper, true);
                        portrayal.draw(portrayedObject, graphics, newinfo);
                        portrayal.setSelected(wrapper, false);
                        continue;
                    }
                    portrayal.draw(portrayedObject, graphics, newinfo);
                }
            }
        } else {
            Bag objects = field.getAllObjects();
            for (int x = 0; x < objects.numObjs; ++x) {
                Object portrayedObject = objects.objs[x];
                Int2D loc = field.getObjectLocation(portrayedObject);
                if (loc.x < startx - 2 || loc.x >= endx + 4 || loc.y < starty - 2 || loc.y >= endy + 4) continue;
                Portrayal p = this.getPortrayalForObject(portrayedObject);
                if (!(p instanceof SimplePortrayal2D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + portrayedObject + " -- expected a SimplePortrayal2D");
                }
                SimplePortrayal2D portrayal = (SimplePortrayal2D)p;
                newinfo.draw.x = (int)(info.draw.x + xScale * (double)loc.x);
                newinfo.draw.y = (int)(info.draw.y + yScale * (double)loc.y);
                newinfo.draw.width = (double)((int)(info.draw.x + xScale * (double)(loc.x + 1))) - newinfo.draw.x;
                newinfo.draw.height = (double)((int)(info.draw.y + yScale * (double)(loc.y + 1))) - newinfo.draw.y;
                newinfo.draw.x += newinfo.draw.width / 2.0;
                newinfo.draw.y += newinfo.draw.height / 2.0;
                if (graphics == null) {
                    if (!portrayal.hitObject(portrayedObject, newinfo)) continue;
                    putInHere.add(this.getWrapper(portrayedObject));
                    continue;
                }
                if (objectSelected && this.selectedWrappers.get(portrayedObject) != null) {
                    LocationWrapper wrapper = (LocationWrapper)this.selectedWrappers.get(portrayedObject);
                    portrayal.setSelected(wrapper, true);
                    portrayal.draw(portrayedObject, graphics, newinfo);
                    portrayal.setSelected(wrapper, false);
                    continue;
                }
                portrayal.draw(portrayedObject, graphics, newinfo);
            }
        }
    }

    public LocationWrapper getWrapper(Object object) {
        SparseGrid2D field = (SparseGrid2D)this.field;
        final StableInt2D w = new StableInt2D(field, object);
        return new LocationWrapper(object, null, this){

            public Object getLocation() {
                w.update();
                return w;
            }

            public String getLocationName() {
                w.update();
                return w.toString();
            }
        };
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (wrapper == null) {
            return true;
        }
        if (wrapper.getFieldPortrayal() != this) {
            return true;
        }
        Object obj = wrapper.getObject();
        if (selected) {
            boolean b = this.getPortrayalForObject(obj).setSelected(wrapper, selected);
            this.getPortrayalForObject(obj).setSelected(wrapper, !selected);
            if (!b) {
                return false;
            }
            this.selectedWrappers.put(obj, wrapper);
        } else {
            this.selectedWrappers.remove(obj);
        }
        return true;
    }
}

