/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import sim.display.GUIState;
import sim.portrayal.inspector.PropertyInspector;
import sim.util.Bag;
import sim.util.Properties;
import sim.util.Utilities;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.SeriesAttributes;

public abstract class ChartingPropertyInspector
extends PropertyInspector {
    protected ChartGenerator generator;
    double lastTime = -1.0;
    SeriesAttributes seriesAttributes;
    static final int AGGREGATIONMETHOD_CURRENT = 0;
    static final int AGGREGATIONMETHOD_MAX = 1;
    static final int AGGREGATIONMETHOD_MIN = 2;
    static final int AGGREGATIONMETHOD_MEAN = 3;
    static final int REDRAW_ALWAYS = 0;
    static final int REDRAW_TENTH_SEC = 1;
    static final int REDRAW_HALF_SEC = 2;
    static final int REDRAW_ONE_SEC = 3;
    static final int REDRAW_TWO_SECS = 4;
    static final int REDRAW_FIVE_SECS = 5;
    static final int REDRAW_TEN_SECS = 6;
    static final int REDRAW_DONT = 7;
    protected GlobalAttributes globalAttributes;
    Thread timer = null;
    boolean updatedOnceAlready = false;

    public ChartGenerator getGenerator() {
        return this.generator;
    }

    protected abstract boolean validChartGenerator(ChartGenerator var1);

    protected abstract ChartGenerator createNewGenerator();

    protected abstract void updateSeries(double var1, double var3);

    protected boolean includeAggregationMethodAttributes() {
        return true;
    }

    public SeriesAttributes getSeriesAttributes() {
        return this.seriesAttributes;
    }

    public ChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.generator = this.chartToUse(properties.getName(index), parent, simulation);
        this.globalAttributes = this.findGlobalAttributes();
        this.validInspector = this.generator != null;
    }

    public ChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, null, simulation);
        if (generator != null) {
            if (!this.validChartGenerator(generator)) {
                throw new RuntimeException("Invalid generator: " + generator);
            }
            this.generator = generator;
        } else {
            this.generator = this.createNewChart(simulation);
        }
        this.globalAttributes = this.findGlobalAttributes();
        this.validInspector = this.generator != null;
    }

    GlobalAttributes findGlobalAttributes() {
        if (this.generator == null) {
            return null;
        }
        int len = this.generator.getGlobalAttributeCount();
        for (int i = 0; i < len; ++i) {
            if (!(this.generator.getGlobalAttribute(i) instanceof GlobalAttributes)) continue;
            return (GlobalAttributes)this.generator.getGlobalAttribute(i);
        }
        return null;
    }

    ChartGenerator chartToUse(String sName, Frame parent, GUIState simulation) {
        Bag charts = new Bag();
        if (simulation.guiObjects != null) {
            for (int i = 0; i < simulation.guiObjects.numObjs; ++i) {
                if (!(simulation.guiObjects.objs[i] instanceof ChartGenerator) || !this.validChartGenerator((ChartGenerator)simulation.guiObjects.objs[i])) continue;
                charts.add(simulation.guiObjects.objs[i]);
            }
        }
        if (charts.numObjs == 0) {
            return this.createNewChart(simulation);
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        String[] chartNames = new String[charts.numObjs + 1];
        chartNames[0] = "[Create a New Chart]";
        for (int i = 0; i < charts.numObjs; ++i) {
            chartNames[i + 1] = ((ChartGenerator)charts.objs[i]).getTitle();
        }
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.setBorder(new TitledBorder("Plot on Chart..."));
        JComboBox<String> encoding = new JComboBox<String>(chartNames);
        panel2.add(encoding, "Center");
        p.add((Component)panel2, "South");
        if (JOptionPane.showConfirmDialog(parent, p, "Create a New Chart...", 2) != 0) {
            return null;
        }
        if (encoding.getSelectedIndex() == 0) {
            return this.createNewChart(simulation);
        }
        return (ChartGenerator)charts.objs[encoding.getSelectedIndex() - 1];
    }

    public void updateBefore(long milliseconds) {
        if (this.timer == null) {
            this.timer = Utilities.doLater(milliseconds, new Runnable(){

                public void run() {
                    if (ChartingPropertyInspector.this.generator != null) {
                        ChartingPropertyInspector.this.generator.update();
                    }
                    ChartingPropertyInspector.this.timer = null;
                }
            });
        }
    }

    ChartGenerator createNewChart(GUIState simulation) {
        this.generator = this.createNewGenerator();
        this.globalAttributes = new GlobalAttributes();
        this.generator.addGlobalAttribute(this.globalAttributes);
        if (simulation.guiObjects == null) {
            simulation.guiObjects = new Bag();
        }
        simulation.guiObjects.add(this.generator);
        JFrame f = this.generator.createFrame(simulation);
        WindowListener wl = new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                ChartingPropertyInspector.this.generator.quit();
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        };
        f.addWindowListener(wl);
        f.setVisible(true);
        return this.generator;
    }

    static String ensureFileEndsWith(String filename, String ending) {
        if (filename.regionMatches(false, filename.length() - ending.length(), ending, 0, ending.length())) {
            return filename;
        }
        return filename + ending;
    }

    public void updateInspector() {
        double time = this.simulation.state.schedule.time();
        if (time >= 0.0 && time < Double.POSITIVE_INFINITY && (this.lastTime < time || !this.updatedOnceAlready)) {
            this.updatedOnceAlready = true;
            this.updateSeries(time, this.lastTime);
            this.lastTime = time;
            switch (this.globalAttributes.redraw) {
                case 0: {
                    this.generator.update();
                    break;
                }
                case 1: {
                    this.updateBefore(100L);
                    break;
                }
                case 2: {
                    this.updateBefore(500L);
                    break;
                }
                case 3: {
                    this.updateBefore(1000L);
                    break;
                }
                case 4: {
                    this.updateBefore(2000L);
                    break;
                }
                case 5: {
                    this.updateBefore(5000L);
                    break;
                }
                case 6: {
                    this.updateBefore(10000L);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    System.err.println("Unknown redraw time specified");
                }
            }
        }
    }

    public boolean shouldCreateFrame() {
        return false;
    }

    protected class GlobalAttributes
    extends JPanel {
        public long interval = 1L;
        public int aggregationMethod = 0;
        public int redraw = 2;

        public GlobalAttributes() {
            this.setLayout(new BorderLayout());
            LabelledList list = new LabelledList(ChartingPropertyInspector.this.includeAggregationMethodAttributes() ? "Add Data..." : "Redraw");
            this.add((Component)list, "Center");
            if (ChartingPropertyInspector.this.includeAggregationMethodAttributes()) {
                NumberTextField stepsField = new NumberTextField(1.0, true){

                    public double newValue(double value) {
                        if ((value = (double)((long)value)) <= 0.0) {
                            return this.currentValue;
                        }
                        GlobalAttributes.this.interval = (long)value;
                        return value;
                    }
                };
                list.addLabelled("Every", stepsField);
                list.addLabelled("", new JLabel("...Timesteps"));
                String[] optionsLabel = new String[]{"Current", "Maximum", "Minimum", "Mean"};
                final JComboBox<String> optionsBox = new JComboBox<String>(optionsLabel);
                optionsBox.setSelectedIndex(this.aggregationMethod);
                optionsBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GlobalAttributes.this.aggregationMethod = optionsBox.getSelectedIndex();
                    }
                });
                list.addLabelled("Using", optionsBox);
            }
            String[] optionsLabel2 = new String[]{"When Adding Data", "Every 0.1 Seconds", "Every 0.5 Seconds", "Every Second", "Every 2 Seconds", "Every 5 Seconds", "Every 10 Seconds", "Never"};
            final JComboBox<String> optionsBox2 = new JComboBox<String>(optionsLabel2);
            optionsBox2.setSelectedIndex(this.redraw);
            optionsBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GlobalAttributes.this.redraw = optionsBox2.getSelectedIndex();
                    ((GlobalAttributes)GlobalAttributes.this).ChartingPropertyInspector.this.generator.update();
                }
            });
            if (ChartingPropertyInspector.this.includeAggregationMethodAttributes()) {
                list.addLabelled("Redraw", optionsBox2);
            } else {
                list.add(optionsBox2);
            }
        }
    }
}

