/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import java.util.Iterator;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import sim.display.GUIState;
import sim.engine.Stoppable;
import sim.portrayal.inspector.ChartingPropertyInspector;
import sim.util.Bag;
import sim.util.IntBag;
import sim.util.Properties;
import sim.util.Valuable;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.DataCuller;
import sim.util.media.chart.TimeSeriesChartGenerator;

public class TimeSeriesChartingPropertyInspector
extends ChartingPropertyInspector {
    XYSeries chartSeries = null;
    XYSeries aggregateSeries = new XYSeries((Comparable)((Object)"ChartingPropertyInspector.temp"), false);
    static Bag tmpBag = new Bag();

    protected boolean validChartGenerator(ChartGenerator generator) {
        return generator instanceof TimeSeriesChartGenerator;
    }

    public static String name() {
        return "Chart";
    }

    public static Class[] types() {
        return new Class[]{Number.class, Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Valuable.class};
    }

    public TimeSeriesChartingPropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        super(properties, index, parent, simulation);
        this.setupSeriesAttributes();
    }

    public TimeSeriesChartingPropertyInspector(Properties properties, int index, GUIState simulation, ChartGenerator generator) {
        super(properties, index, simulation, generator);
        this.setupSeriesAttributes();
    }

    private void setupSeriesAttributes() {
        if (this.validInspector) {
            this.chartSeries = new XYSeries((Comparable)((Object)this.properties.getName(this.index)), false);
            this.seriesAttributes = ((TimeSeriesChartGenerator)this.generator).addSeries(this.chartSeries, new SeriesChangeListener(){

                public void seriesChanged(SeriesChangeEvent event) {
                    TimeSeriesChartingPropertyInspector.this.getStopper().stop();
                }
            });
        }
    }

    protected ChartGenerator createNewGenerator() {
        return new TimeSeriesChartGenerator(){

            public void quit() {
                super.quit();
                Stoppable stopper = TimeSeriesChartingPropertyInspector.this.getStopper();
                if (stopper != null) {
                    stopper.stop();
                }
                if (TimeSeriesChartingPropertyInspector.this.simulation.guiObjects != null) {
                    TimeSeriesChartingPropertyInspector.this.simulation.guiObjects.remove(this);
                }
            }
        };
    }

    protected double valueFor(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Valuable) {
            return ((Valuable)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        return Double.NaN;
    }

    public void addToMainSeries(double x, double y, boolean notify) {
        this.chartSeries.add(x, y, false);
        DataCuller dataCuller = ((TimeSeriesChartGenerator)this.generator).getDataCuller();
        if (dataCuller != null && dataCuller.tooManyPoints(this.chartSeries.getItemCount())) {
            this.deleteItems(dataCuller.cull(this.getXValues(), true));
        } else if (notify) {
            this.chartSeries.fireSeriesChanged();
        }
    }

    void deleteItems(IntBag items) {
        if (items.numObjs == 0) {
            return;
        }
        tmpBag.clear();
        int currentTabooIndex = 0;
        int currentTaboo = items.objs[0];
        Iterator iter = this.chartSeries.getItems().iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (index == currentTaboo) {
                currentTaboo = currentTabooIndex < items.numObjs - 1 ? items.objs[++currentTabooIndex] : -1;
            } else {
                tmpBag.add(o);
            }
            ++index;
        }
        this.chartSeries.clear();
        for (int i = 0; i < TimeSeriesChartingPropertyInspector.tmpBag.numObjs; ++i) {
            this.chartSeries.add((XYDataItem)TimeSeriesChartingPropertyInspector.tmpBag.objs[i], false);
        }
        tmpBag.clear();
        this.chartSeries.fireSeriesChanged();
    }

    double[] getXValues() {
        double[] xValues = new double[this.chartSeries.getItemCount()];
        for (int i = 0; i < xValues.length; ++i) {
            xValues[i] = this.chartSeries.getX(i).doubleValue();
        }
        return xValues;
    }

    protected void updateSeries(double time, double lastTime) {
        double d = 0.0;
        d = this.valueFor(this.properties.getValue(this.index));
        this.aggregateSeries.add(time, d, false);
        int len = this.aggregateSeries.getItemCount();
        long interval = this.globalAttributes.interval;
        double intervalMark = time % (double)interval;
        if (intervalMark != 0.0 && !(time - lastTime >= (double)interval) && !(lastTime % (double)interval > intervalMark)) {
            return;
        }
        double y = 0.0;
        switch (this.globalAttributes.aggregationMethod) {
            case 0: {
                this.addToMainSeries(time, d, false);
                break;
            }
            case 1: {
                double maxX = 0.0;
                for (int i = 0; i < len; ++i) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    double temp = item.getX().doubleValue();
                    if (!(maxX < temp) && i != 0) continue;
                    maxX = temp;
                }
                this.addToMainSeries(maxX, y, false);
                break;
            }
            case 2: {
                double minX = 0.0;
                for (int i = 0; i < len; ++i) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    double temp = item.getX().doubleValue();
                    if (!(minX > temp) && i != 0) continue;
                    minX = temp;
                }
                this.addToMainSeries(minX, y, false);
                break;
            }
            case 3: {
                double sumX = 0.0;
                int n = 0;
                for (int i = 0; i < len; ++i) {
                    XYDataItem item = this.aggregateSeries.getDataItem(i);
                    y = item.getY().doubleValue();
                    sumX += item.getX().doubleValue();
                    ++n;
                }
                if (n == 0) {
                    System.err.println("No element????");
                    break;
                }
                this.addToMainSeries(sumX / (double)n, y, false);
                break;
            }
            default: {
                System.err.println("There are only four aggregation method implemented");
            }
        }
        this.aggregateSeries.clear();
    }
}

