/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sim.field.continuous.Continuous2D;
import sim.field.network.Edge;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.network.EdgeDrawInfo2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.util.Bag;
import sim.util.Double2D;

public class NetworkPortrayal2D
extends FieldPortrayal2D {
    SimpleEdgePortrayal2D defaultPortrayal = new SimpleEdgePortrayal2D();

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public void setField(Object field) {
        this.dirtyField = true;
        if (!(field instanceof SpatialNetwork2D)) {
            throw new RuntimeException("Invalid field for FieldPortrayal2D: " + field);
        }
        this.field = field;
    }

    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        SpatialNetwork2D field = (SpatialNetwork2D)this.field;
        if (field == null) {
            return;
        }
        double xScale = info.draw.width / field.getWidth();
        double yScale = info.draw.height / field.getHeight();
        EdgeDrawInfo2D newinfo = new EdgeDrawInfo2D(new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip, new Point2D.Double(0.0, 0.0));
        Bag nodes = field.network.getAllNodes();
        for (int x = 0; x < nodes.numObjs; ++x) {
            Bag edges = field.network.getEdgesOut(nodes.objs[x]);
            Double2D locStart = field.getObjectLocation(nodes.objs[x]);
            if (locStart == null) continue;
            if (field.field instanceof Continuous2D) {
                newinfo.draw.x = info.draw.x + xScale * locStart.x;
                newinfo.draw.y = info.draw.y + yScale * locStart.y;
            } else {
                newinfo.draw.x = (int)(info.draw.x + xScale * locStart.x);
                newinfo.draw.y = (int)(info.draw.y + yScale * locStart.y);
                double width = (double)((int)(info.draw.x + xScale * (locStart.x + 1.0))) - newinfo.draw.x;
                double height = (double)((int)(info.draw.y + yScale * (locStart.y + 1.0))) - newinfo.draw.y;
                newinfo.draw.x += width / 2.0;
                newinfo.draw.y += height / 2.0;
            }
            for (int y = 0; y < edges.numObjs; ++y) {
                Edge edge = (Edge)edges.objs[y];
                Double2D locStop = field.getObjectLocation(edge.to());
                if (locStop == null) continue;
                if (field.field instanceof Continuous2D) {
                    newinfo.secondPoint.x = info.draw.x + xScale * locStop.x;
                    newinfo.secondPoint.y = info.draw.y + yScale * locStop.y;
                } else {
                    newinfo.secondPoint.x = (int)(info.draw.x + xScale * locStop.x);
                    newinfo.secondPoint.y = (int)(info.draw.y + yScale * locStop.y);
                    double width = (double)((int)(info.draw.x + xScale * (locStop.x + 1.0))) - newinfo.secondPoint.x;
                    double height = (double)((int)(info.draw.y + yScale * (locStop.y + 1.0))) - newinfo.secondPoint.y;
                    newinfo.secondPoint.x += width / 2.0;
                    newinfo.secondPoint.y += height / 2.0;
                }
                Portrayal p = this.getPortrayalForObject(edge);
                if (!(p instanceof SimpleEdgePortrayal2D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + edge + " -- expected a SimpleEdgePortrayal2D");
                }
                SimpleEdgePortrayal2D portrayal = (SimpleEdgePortrayal2D)p;
                if (graphics == null) {
                    if (!portrayal.hitObject(edge, newinfo)) continue;
                    putInHere.add(this.getWrapper(edge));
                    continue;
                }
                portrayal.draw(edge, graphics, newinfo);
            }
        }
    }

    public LocationWrapper getWrapper(Edge edge) {
        final SpatialNetwork2D field = (SpatialNetwork2D)this.field;
        return new LocationWrapper(edge.info, edge, this){

            public String getLocationName() {
                Edge edge = (Edge)this.getLocation();
                if (field != null && field.network != null) {
                    Bag b = field.network.getEdgesOut(edge.from());
                    for (int x = 0; x < b.numObjs; ++x) {
                        if (b.objs[x] != edge) continue;
                        return "" + edge.from() + " --> " + edge.to();
                    }
                }
                return "Gone.  Was: " + edge.from() + " --> " + edge.to();
            }
        };
    }
}

