/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import sim.field.network.Edge;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.network.EdgeDrawInfo2D;

public class SimpleEdgePortrayal2D
extends SimplePortrayal2D {
    public Paint fromPaint;
    public Paint toPaint;
    public Paint labelPaint;
    public Font labelFont;
    Font scaledFont;
    int labelScaling = 2;
    int scaling = 2;
    public static final int NEVER_SCALE = 0;
    public static final int SCALE_WHEN_SMALLER = 1;
    public static final int ALWAYS_SCALE = 2;
    public double baseWidth;
    public static final int SHAPE_LINE = 0;
    public static final int SHAPE_TRIANGLE = 1;
    public int shape;
    Line2D.Double preciseLine = new Line2D.Double();
    GeneralPath precisePoly = new GeneralPath();
    int[] xPoints = new int[3];
    int[] yPoints = new int[3];

    public SimpleEdgePortrayal2D() {
        this(Color.black, null);
    }

    public SimpleEdgePortrayal2D(Paint edgePaint, Paint labelPaint) {
        this(edgePaint, edgePaint, labelPaint);
    }

    public SimpleEdgePortrayal2D(Paint fromPaint, Paint toPaint, Paint labelPaint) {
        this(fromPaint, toPaint, labelPaint, new Font("SansSerif", 0, 12));
    }

    public SimpleEdgePortrayal2D(Paint fromPaint, Paint toPaint, Paint labelPaint, Font labelFont) {
        this.fromPaint = fromPaint;
        this.toPaint = toPaint;
        this.labelPaint = labelPaint;
        this.labelFont = labelFont;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public double getBaseWidth() {
        return this.baseWidth;
    }

    public void setBaseWidth(double val) {
        this.baseWidth = val;
    }

    public int getScaling() {
        return this.labelScaling;
    }

    public void setScaling(int val) {
        if (val >= 0 && val <= 2) {
            this.labelScaling = val;
        }
    }

    public int getLabelScaling() {
        return this.labelScaling;
    }

    public void setLabelScaling(int val) {
        if (val >= 0 && val <= 2) {
            this.labelScaling = val;
        }
    }

    public String getLabel(Edge edge, EdgeDrawInfo2D info) {
        Object obj = edge.info;
        if (obj == null) {
            return "";
        }
        return "" + obj;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (!(info instanceof EdgeDrawInfo2D)) {
            throw new RuntimeException("Expected this to be an EdgeDrawInfo2D: " + info);
        }
        EdgeDrawInfo2D e = (EdgeDrawInfo2D)info;
        double startXd = e.draw.x;
        double startYd = e.draw.y;
        double endXd = e.secondPoint.x;
        double endYd = e.secondPoint.y;
        double midXd = (startXd + endXd) / 2.0;
        double midYd = (startYd + endYd) / 2.0;
        int startX = (int)startXd;
        int startY = (int)startYd;
        int endX = (int)endXd;
        int endY = (int)endYd;
        int midX = (int)midXd;
        int midY = (int)midYd;
        if (this.shape == 1) {
            graphics.setPaint(this.fromPaint);
            double len = Math.sqrt((startXd - endXd) * (startXd - endXd) + (startYd - endYd) * (startYd - endYd));
            double vecX = (startXd - endXd) * this.baseWidth * 0.5 / len;
            double vecY = (startYd - endYd) * this.baseWidth * 0.5 / len;
            double scaleWidth = info.draw.width;
            double scaleHeight = info.draw.height;
            this.xPoints[0] = endX;
            this.yPoints[0] = endY;
            if (this.scaling == 1 && info.draw.width >= 1.0 || this.scaling == 0) {
                scaleWidth = 1.0;
                scaleHeight = 1.0;
            }
            if (info.precise) {
                this.precisePoly.reset();
                this.precisePoly.moveTo((float)endXd, (float)endYd);
                this.precisePoly.lineTo((float)(startXd + vecY * scaleWidth), (float)(startYd + -vecX * scaleHeight));
                this.precisePoly.lineTo((float)(startXd + -vecY * scaleWidth), (float)(startYd + vecX * scaleHeight));
                this.precisePoly.lineTo((float)endXd, (float)endYd);
                graphics.fill(this.precisePoly);
            } else {
                this.xPoints[1] = (int)(startXd + vecY * scaleWidth);
                this.yPoints[1] = (int)(startYd + -vecX * scaleHeight);
                this.xPoints[2] = (int)(startXd + -vecY * scaleWidth);
                this.yPoints[2] = (int)(startYd + vecX * scaleHeight);
                graphics.fillPolygon(this.xPoints, this.yPoints, 3);
                graphics.drawPolygon(this.xPoints, this.yPoints, 3);
            }
        } else if (this.fromPaint == this.toPaint) {
            graphics.setPaint(this.fromPaint);
            if (info.precise) {
                this.preciseLine.setLine(startXd, startYd, endXd, endYd);
                graphics.draw(this.preciseLine);
            } else {
                graphics.drawLine(startX, startY, endX, endY);
            }
        } else {
            graphics.setPaint(this.fromPaint);
            if (info.precise) {
                this.preciseLine.setLine(startXd, startYd, midXd, midYd);
                graphics.draw(this.preciseLine);
                graphics.setPaint(this.toPaint);
                this.preciseLine.setLine(midXd, midYd, endXd, endYd);
                graphics.draw(this.preciseLine);
            } else {
                graphics.drawLine(startX, startY, midX, midY);
                graphics.setPaint(this.toPaint);
                graphics.drawLine(midX, midY, endX, endY);
            }
        }
        if (this.labelPaint != null) {
            String information;
            float size;
            Font labelFont = this.labelFont;
            Font scaledFont = this.scaledFont;
            float f = size = this.labelScaling == 2 || this.labelScaling == 1 && info.draw.width < 1.0 ? (float)(info.draw.width * (double)labelFont.getSize2D()) : labelFont.getSize2D();
            if (scaledFont == null || scaledFont.getSize2D() != size || scaledFont.getFamily() != labelFont.getFamily() || scaledFont.getStyle() != labelFont.getStyle()) {
                scaledFont = this.scaledFont = labelFont.deriveFont(size);
            }
            if ((information = this.getLabel((Edge)object, e)).length() > 0) {
                graphics.setPaint(this.labelPaint);
                graphics.setFont(scaledFont);
                int width = graphics.getFontMetrics().stringWidth(information);
                graphics.drawString(information, midX - width / 2, midY);
            }
        }
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        if (!(range instanceof EdgeDrawInfo2D)) {
            throw new RuntimeException("Expected this to be an EdgeDrawInfo2D: " + range);
        }
        EdgeDrawInfo2D e = (EdgeDrawInfo2D)range;
        double startXd = e.draw.x;
        double startYd = e.draw.y;
        double endXd = e.secondPoint.x;
        double endYd = e.secondPoint.y;
        double SLOP = 5.0;
        if (this.baseWidth == 0.0) {
            Line2D.Double line = new Line2D.Double(startXd, startYd, endXd, endYd);
            return line.intersects(range.clip.x - 5.0, range.clip.y - 5.0, range.clip.width + 10.0, range.clip.height + 10.0);
        }
        double len = Math.sqrt((startXd - endXd) * (startXd - endXd) + (startYd - endYd) * (startYd - endYd));
        double vecX = (startXd - endXd) * this.baseWidth * 0.5 / len;
        double vecY = (startYd - endYd) * this.baseWidth * 0.5 / len;
        double scaleWidth = range.draw.width;
        double scaleHeight = range.draw.height;
        this.xPoints[0] = (int)endXd;
        this.yPoints[0] = (int)endYd;
        if (this.scaling == 1 && range.draw.width >= 1.0 || this.scaling == 0) {
            scaleWidth = 1.0;
            scaleHeight = 1.0;
        }
        this.xPoints[1] = (int)(startXd + vecY * scaleWidth);
        this.yPoints[1] = (int)(startYd + -vecX * scaleHeight);
        this.xPoints[2] = (int)(startXd + -vecY * scaleWidth);
        this.yPoints[2] = (int)(startYd + vecX * scaleHeight);
        Polygon poly = new Polygon(this.xPoints, this.yPoints, 3);
        return poly.intersects(range.clip.x - 5.0, range.clip.y - 5.0, range.clip.width + 10.0, range.clip.height + 10.0);
    }

    public String getName(LocationWrapper wrapper) {
        return "Edge: " + super.getName(wrapper);
    }
}

