/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network;

import sim.field.SparseField;
import sim.field.continuous.Continuous2D;
import sim.field.grid.SparseGrid2D;
import sim.field.network.Network;
import sim.util.Double2D;

public class SpatialNetwork2D {
    public SparseField field;
    public SparseField field2;
    public Network network;

    public SpatialNetwork2D(Continuous2D field, Network network) {
        this.field = field;
        if (field == null) {
            throw new RuntimeException("Null Continuous2D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public SpatialNetwork2D(SparseGrid2D grid, Network network) {
        this.field = grid;
        if (this.field == null) {
            throw new RuntimeException("Null SparseGrid2D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public void setAuxillaryField(Continuous2D f) {
        this.field2 = f;
        if (this.field2 != null && this.field instanceof SparseGrid2D) {
            throw new RuntimeException("The auxillary field of a SpatialNetwork2D should be the same type as the primary field.");
        }
    }

    public void setAuxillaryField(SparseGrid2D f) {
        this.field2 = f;
        if (this.field2 != null && this.field instanceof Continuous2D) {
            throw new RuntimeException("The auxillary field of a SpatialNetwork2D should be the same type as the primary field.");
        }
    }

    public Double2D getObjectLocation(Object node) {
        Double2D loc = null;
        loc = this.field instanceof Continuous2D ? ((Continuous2D)this.field).getObjectLocation(node) : ((SparseGrid2D)this.field).getObjectLocationAsDouble2D(node);
        if (loc == null && this.field2 != null) {
            loc = this.field2 instanceof Continuous2D ? ((Continuous2D)this.field2).getObjectLocation(node) : ((SparseGrid2D)this.field2).getObjectLocationAsDouble2D(node);
        }
        return loc;
    }

    public double getWidth() {
        if (this.field instanceof Continuous2D) {
            return ((Continuous2D)this.field).getWidth();
        }
        return ((SparseGrid2D)this.field).getWidth();
    }

    public double getHeight() {
        if (this.field instanceof Continuous2D) {
            return ((Continuous2D)this.field).getHeight();
        }
        return ((SparseGrid2D)this.field).getHeight();
    }
}

