/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import sim.display.GUIState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.simple.OvalPortrayal2D;

public class CircledPortrayal2D
extends OvalPortrayal2D {
    public static final double DEFAULT_SCALE = 2.0;
    public static final double DEFAULT_OFFSET = 0.0;
    public SimplePortrayal2D child;
    boolean showCircle = true;
    boolean onlyCircleWhenSelected;
    boolean isSelected = false;

    public void setOnlyCircleWhenSelected(boolean val) {
        this.onlyCircleWhenSelected = val;
    }

    public boolean getOnlyCircleWhenSelected() {
        return this.onlyCircleWhenSelected;
    }

    public boolean isCircleShowing() {
        return this.showCircle;
    }

    public void setCircleShowing(boolean val) {
        this.showCircle = val;
    }

    public CircledPortrayal2D(SimplePortrayal2D child, double offset, double scale, Paint paint, boolean onlyCircleWhenSelected) {
        super(paint, scale, false);
        this.offset = offset;
        this.child = child;
        this.paint = paint;
        this.onlyCircleWhenSelected = onlyCircleWhenSelected;
    }

    public CircledPortrayal2D(SimplePortrayal2D child) {
        this(child, Color.blue, false);
    }

    public CircledPortrayal2D(SimplePortrayal2D child, Paint paint, boolean onlyCircleWhenSelected) {
        this(child, 0.0, 2.0, paint, onlyCircleWhenSelected);
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to CircledPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        this.getChild(object).draw(object, graphics, info);
        if (this.showCircle && (this.isSelected || !this.onlyCircleWhenSelected)) {
            super.draw(object, graphics, info);
        }
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        return this.getChild(object).hitObject(object, range);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        this.isSelected = selected;
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

