/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import sim.display.GUIState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Oriented2D;
import sim.portrayal.SimplePortrayal2D;

public class OrientedPortrayal2D
extends SimplePortrayal2D {
    public static final double DEFAULT_OR = 0.5;
    public static final int DEFAULT_DR = 0;
    public static final int SHAPE_LINE = 0;
    public static final int SHAPE_KITE = 1;
    public static final int SHAPE_COMPASS = 2;
    int shape = 0;
    public double or;
    public int dr;
    public Paint paint;
    public SimplePortrayal2D child;
    boolean showLine = true;
    int[] simplePolygonX = new int[4];
    int[] simplePolygonY = new int[4];
    boolean orientationHittable = true;

    public void setShape(int val) {
        if (val >= 0 && val <= 2) {
            this.shape = val;
        }
    }

    public int getShape() {
        return this.shape;
    }

    public boolean isLineShowing() {
        return this.showLine;
    }

    public void setLineShowing(boolean val) {
        this.showLine = val;
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int dr, double or, Paint paint, int shape) {
        this.dr = dr;
        this.or = or;
        this.child = child;
        this.paint = paint;
        this.shape = shape;
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int dr, double or, Paint paint) {
        this(child, dr, or, paint, 0);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child) {
        this(child, 0, 0.5, Color.red);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int dr, double or) {
        this(child, dr, or, Color.red);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, Paint paint) {
        this(child, 0, 0.5, paint);
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to OrientedPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        this.getChild(object).draw(object, graphics, info);
        if (this.showLine && object != null && object instanceof Oriented2D) {
            double theta = ((Oriented2D)object).orientation2D();
            int length = (int)(this.or * (info.draw.width < info.draw.height ? info.draw.width : info.draw.height)) + this.dr;
            double lenx = Math.cos(theta) * (double)length;
            double leny = Math.sin(theta) * (double)length;
            int x = (int)(info.draw.x + lenx);
            int y = (int)(info.draw.y + leny);
            graphics.setPaint(this.paint);
            switch (this.shape) {
                default: {
                    graphics.drawLine((int)info.draw.x, (int)info.draw.y, x, y);
                    break;
                }
                case 1: {
                    this.simplePolygonX[0] = x;
                    this.simplePolygonY[0] = y;
                    this.simplePolygonX[1] = (int)(info.draw.x + -leny + -lenx);
                    this.simplePolygonY[1] = (int)(info.draw.y + lenx + -leny);
                    this.simplePolygonX[2] = (int)(info.draw.x + -lenx / 2.0);
                    this.simplePolygonY[2] = (int)(info.draw.y + -leny / 2.0);
                    this.simplePolygonX[3] = (int)(info.draw.x + leny + -lenx);
                    this.simplePolygonY[3] = (int)(info.draw.y + -lenx + -leny);
                    graphics.fillPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                    break;
                }
                case 2: {
                    this.simplePolygonX[0] = (int)(info.draw.x + lenx);
                    this.simplePolygonY[0] = (int)(info.draw.y + leny);
                    this.simplePolygonX[1] = (int)(info.draw.x + -leny / 2.0);
                    this.simplePolygonY[1] = (int)(info.draw.y + lenx / 2.0);
                    this.simplePolygonX[2] = (int)(info.draw.x + -lenx / 2.0);
                    this.simplePolygonY[2] = (int)(info.draw.y + -leny / 2.0);
                    this.simplePolygonX[3] = (int)(info.draw.x + leny / 2.0);
                    this.simplePolygonY[3] = (int)(info.draw.y + -lenx / 2.0);
                    graphics.fillPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                }
            }
        }
    }

    public boolean isOrientationHittable() {
        return this.orientationHittable;
    }

    public void setOrientationHittable(boolean val) {
        this.orientationHittable = val;
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        if (this.getChild(object).hitObject(object, range)) {
            return true;
        }
        if (!this.orientationHittable) {
            return false;
        }
        if (this.showLine && object != null && object instanceof Oriented2D) {
            double theta = ((Oriented2D)object).orientation2D();
            int length = (int)(this.or * (range.draw.width < range.draw.height ? range.draw.width : range.draw.height)) + this.dr;
            double lenx = Math.cos(theta) * (double)length;
            double leny = Math.sin(theta) * (double)length;
            int x = (int)(range.draw.x + lenx);
            int y = (int)(range.draw.y + leny);
            switch (this.shape) {
                default: {
                    break;
                }
                case 1: {
                    this.simplePolygonX[0] = x;
                    this.simplePolygonY[0] = y;
                    this.simplePolygonX[1] = (int)(range.draw.x + -leny + -lenx);
                    this.simplePolygonY[1] = (int)(range.draw.y + lenx + -leny);
                    this.simplePolygonX[2] = (int)(range.draw.x + -lenx / 2.0);
                    this.simplePolygonY[2] = (int)(range.draw.y + -leny / 2.0);
                    this.simplePolygonX[3] = (int)(range.draw.x + leny + -lenx);
                    this.simplePolygonY[3] = (int)(range.draw.y + -lenx + -leny);
                    return new Polygon(this.simplePolygonX, this.simplePolygonY, 4).intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
                }
                case 2: {
                    this.simplePolygonX[0] = (int)(range.draw.x + lenx);
                    this.simplePolygonY[0] = (int)(range.draw.y + leny);
                    this.simplePolygonX[1] = (int)(range.draw.x + -leny / 2.0);
                    this.simplePolygonY[1] = (int)(range.draw.y + lenx / 2.0);
                    this.simplePolygonX[2] = (int)(range.draw.x + -lenx / 2.0);
                    this.simplePolygonY[2] = (int)(range.draw.y + -leny / 2.0);
                    this.simplePolygonX[3] = (int)(range.draw.x + leny / 2.0);
                    this.simplePolygonY[3] = (int)(range.draw.y + -lenx / 2.0);
                    return new Polygon(this.simplePolygonX, this.simplePolygonY, 4).intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
                }
            }
        }
        return false;
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

