/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.SimplePortrayal2D;

public class RectanglePortrayal2D
extends SimplePortrayal2D {
    public Paint paint;
    public double scale;
    public boolean filled;
    Rectangle2D.Double preciseRectangle = new Rectangle2D.Double();

    public RectanglePortrayal2D() {
        this(Color.gray, 1.0, true);
    }

    public RectanglePortrayal2D(Paint paint) {
        this(paint, 1.0, true);
    }

    public RectanglePortrayal2D(double scale) {
        this(Color.gray, scale, true);
    }

    public RectanglePortrayal2D(Paint paint, double scale) {
        this(paint, scale, true);
    }

    public RectanglePortrayal2D(Paint paint, boolean filled) {
        this(paint, 1.0, filled);
    }

    public RectanglePortrayal2D(double scale, boolean filled) {
        this(Color.gray, scale, filled);
    }

    public RectanglePortrayal2D(Paint paint, double scale, boolean filled) {
        this.paint = paint;
        this.scale = scale;
        this.filled = filled;
    }

    public boolean hitObject(Object object, DrawInfo2D range) {
        double width = range.draw.width * this.scale;
        double height = range.draw.height * this.scale;
        return range.clip.intersects(range.draw.x - width / 2.0, range.draw.y - height / 2.0, width, height);
    }

    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        Rectangle2D.Double draw = info.draw;
        double width = draw.width * this.scale;
        double height = draw.height * this.scale;
        if (info.precise) {
            this.preciseRectangle.setFrame(info.draw.x - width / 2.0, info.draw.y - height / 2.0, width, height);
            if (this.filled) {
                graphics.fill(this.preciseRectangle);
            } else {
                graphics.draw(this.preciseRectangle);
            }
            return;
        }
        graphics.setPaint(this.paint);
        int x = (int)(draw.x - width / 2.0);
        int y = (int)(draw.y - height / 2.0);
        int w = (int)width;
        int h = (int)height;
        if (this.filled) {
            graphics.fillRect(x, y, w, h);
        } else {
            graphics.drawRect(x, y, w, h);
        }
    }
}

