/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import sim.display.GUIState;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimpleInspector;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;

public class SimplePortrayal3D
implements Portrayal3D {
    public static final Appearance DEFAULT_APPEARANCE = SimplePortrayal3D.appearanceForColor(Color.white);
    static final Color3f BLACK = new Color3f(Color.black);
    protected FieldPortrayal3D parentPortrayal = null;
    HashMap selectedObjects = null;

    public static Appearance appearanceForColor(Color unlitColor) {
        Appearance appearance = new Appearance();
        SimplePortrayal3D.setAppearanceFlags(appearance);
        float[] c = unlitColor.getRGBComponents(null);
        ColoringAttributes ca = new ColoringAttributes(c[0], c[1], c[2], 2);
        ca.setCapability(1);
        ca.setCapability(0);
        appearance.setColoringAttributes(ca);
        if ((double)c[3] < 1.0) {
            TransparencyAttributes tta = new TransparencyAttributes(2, 1.0f - c[3]);
            tta.setCapability(3);
            tta.setCapability(2);
            appearance.setTransparencyAttributes(tta);
        }
        return appearance;
    }

    public static Appearance appearanceForColors(Color ambientColor, Color emissiveColor, Color diffuseColor, Color specularColor, float shininess, float opacity) {
        Appearance appearance = new Appearance();
        SimplePortrayal3D.setAppearanceFlags(appearance);
        ColoringAttributes ca = new ColoringAttributes(BLACK, 3);
        ca.setCapability(1);
        ca.setCapability(0);
        appearance.setColoringAttributes(ca);
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (shininess > 1.0f) {
            shininess = 1.0f;
        }
        if (shininess < 0.0f) {
            shininess = 0.0f;
        }
        shininess = shininess * 63.0f + 1.0f;
        Material m = new Material();
        m.setCapability(0);
        m.setCapability(1);
        if (ambientColor != null) {
            m.setAmbientColor(new Color3f(ambientColor));
        } else {
            m.setAmbientColor(BLACK);
        }
        if (emissiveColor != null) {
            m.setEmissiveColor(new Color3f(emissiveColor));
        } else {
            m.setEmissiveColor(BLACK);
        }
        if (diffuseColor != null) {
            m.setDiffuseColor(new Color3f(diffuseColor));
        } else {
            m.setDiffuseColor(BLACK);
        }
        if (specularColor != null) {
            m.setSpecularColor(new Color3f(specularColor));
        } else {
            m.setSpecularColor(BLACK);
        }
        m.setShininess(shininess);
        appearance.setMaterial(m);
        if (opacity < 1.0f) {
            TransparencyAttributes tta = new TransparencyAttributes(2, 1.0f - opacity);
            tta.setCapability(3);
            tta.setCapability(2);
            appearance.setTransparencyAttributes(tta);
        }
        return appearance;
    }

    public static Appearance appearanceForImage(Image image, boolean opaque) {
        Appearance appearance = SimplePortrayal3D.appearanceForColor(Color.black);
        if (!opaque) {
            TransparencyAttributes tta = new TransparencyAttributes(2, 1.0f);
            tta.setCapability(3);
            tta.setCapability(2);
            appearance.setTransparencyAttributes(tta);
        }
        appearance.setTexture(new TextureLoader(image, 2, null).getTexture());
        TextureAttributes ta = new TextureAttributes();
        ta.setTextureMode(5);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        appearance.setPolygonAttributes(pa);
        appearance.setTextureAttributes(ta);
        return appearance;
    }

    public PolygonAttributes polygonAttributes() {
        return null;
    }

    public TransformGroup getModel(Object object, TransformGroup prev) {
        if (prev == null) {
            prev = new TransformGroup();
        }
        return prev;
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        if (wrapper == null) {
            return null;
        }
        return new SimpleInspector(wrapper.getObject(), state, "Properties");
    }

    public String getStatus(LocationWrapper wrapper) {
        return this.getName(wrapper);
    }

    public String getName(LocationWrapper wrapper) {
        if (wrapper == null) {
            return "";
        }
        return "" + wrapper.getObject();
    }

    public void setParentPortrayal(FieldPortrayal3D p) {
        this.parentPortrayal = p;
    }

    public boolean isSelected(Object obj) {
        return this.selectedObjects != null && this.selectedObjects.containsKey(obj);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (this.selectedObjects == null) {
            this.selectedObjects = new HashMap(1);
        }
        if (selected) {
            this.selectedObjects.put(wrapper.getObject(), wrapper);
        } else {
            this.selectedObjects.remove(wrapper.getObject());
        }
        return true;
    }

    public static void setAppearanceFlags(Appearance a) {
        a.setCapability(8);
        a.clearCapabilityIsFrequent(8);
        a.setCapability(9);
        a.clearCapabilityIsFrequent(9);
        a.setCapability(0);
        a.clearCapabilityIsFrequent(0);
        a.setCapability(1);
        a.clearCapabilityIsFrequent(1);
        a.setCapability(14);
        a.clearCapabilityIsFrequent(14);
        a.setCapability(15);
        a.clearCapabilityIsFrequent(15);
        a.setCapability(10);
        a.clearCapabilityIsFrequent(10);
        a.setCapability(11);
        a.clearCapabilityIsFrequent(11);
        a.setCapability(6);
        a.clearCapabilityIsFrequent(6);
        a.setCapability(7);
        a.clearCapabilityIsFrequent(7);
        a.setCapability(2);
        a.clearCapabilityIsFrequent(2);
        a.setCapability(3);
        a.clearCapabilityIsFrequent(3);
    }

    public static void setPickableFlags(Shape3D s3d) {
        s3d.setCapability(12);
        SimplePortrayal3D.setPickableFlags(s3d.getGeometry());
        s3d.clearCapabilityIsFrequent(12);
    }

    public static void setPickableFlags(Geometry geom) {
        geom.setCapability(8);
        geom.setCapability(17);
        geom.setCapability(0);
        geom.clearCapabilityIsFrequent(8);
        geom.clearCapabilityIsFrequent(17);
        geom.clearCapabilityIsFrequent(0);
    }

    public static void clearPickableFlags(Node n) {
        n.setPickable(false);
        n.clearCapability(1);
    }
}

