/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.util.BitSet;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import sim.field.grid.AbstractGrid2D;
import sim.field.grid.AbstractGrid3D;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.DoubleGrid3D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.IntGrid3D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.simple.ValuePortrayal3D;
import sim.util.MutableDouble;
import sim.util.gui.ColorMap;
import sim.util.gui.SimpleColorMap;

public class ValueGridPortrayal3D
extends FieldPortrayal3D {
    String valueName;
    public double scale;
    public ColorMap map = new SimpleColorMap();
    ValuePortrayal3D defaultPortrayal = new ValuePortrayal3D();
    int width;
    int height;
    int length;
    final MutableDouble valueToPass = new MutableDouble(0.0);

    public ColorMap getMap() {
        return this.map;
    }

    public void setMap(ColorMap m) {
        this.map = m;
    }

    public String getValueName() {
        return this.valueName;
    }

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public void setField(Object field) {
        if (field instanceof IntGrid3D || field instanceof DoubleGrid3D) {
            this.field = (AbstractGrid3D)field;
        } else if (field instanceof IntGrid2D || field instanceof DoubleGrid2D) {
            this.field = (AbstractGrid2D)field;
        } else {
            throw new RuntimeException("Invalid field for ValueGridPortrayal3D: " + field);
        }
    }

    public Object getField() {
        return this.field;
    }

    public ValueGridPortrayal3D() {
        this("Value", 1.0);
    }

    public ValueGridPortrayal3D(String valueName) {
        this(valueName, 1.0);
    }

    public ValueGridPortrayal3D(double s) {
        this("Value", s);
    }

    public ValueGridPortrayal3D(String valueName, double scale) {
        this.valueName = valueName;
        this.scale = scale;
    }

    public PolygonAttributes polygonAttributes() {
        return ((Portrayal3D)this.getPortrayalForObject(new ValuePortrayal3D.ValueWrapper(0.0, 0, 0, 0, this))).polygonAttributes();
    }

    public double newValue(int x, int y, int z) {
        if (this.field instanceof DoubleGrid3D) {
            return ((DoubleGrid3D)this.field).field[x][y][z];
        }
        if (this.field instanceof IntGrid3D) {
            return ((IntGrid3D)this.field).field[x][y][z];
        }
        if (this.field instanceof DoubleGrid2D) {
            return ((DoubleGrid2D)this.field).field[x][y];
        }
        return ((IntGrid2D)this.field).field[x][y];
    }

    public TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        if (this.field == null) {
            return globalTG;
        }
        Switch localSwitch = new Switch(-3);
        localSwitch.setCapability(17);
        localSwitch.setCapability(18);
        localSwitch.setCapability(12);
        globalTG.addChild((Node)localSwitch);
        this.extractDimensions();
        BitSet childMask = new BitSet(this.width * this.height * this.length);
        Transform3D trans = new Transform3D();
        Portrayal p = this.getPortrayalForObject(new ValuePortrayal3D.ValueWrapper(0.0, 0, 0, 0, this));
        if (!(p instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + "for object " + this.valueToPass + " -- expected a SimplePortrayal3D");
        }
        SimplePortrayal3D portrayal = (SimplePortrayal3D)p;
        portrayal.setParentPortrayal(this);
        int i = 0;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    double value = this.newValue(x, y, z);
                    ValuePortrayal3D.ValueWrapper wrapper = new ValuePortrayal3D.ValueWrapper(value, x, y, z, this);
                    TransformGroup tg = portrayal.getModel(wrapper, null);
                    tg.setCapability(12);
                    trans.setTranslation(new Vector3f((float)x, (float)y, (float)z));
                    trans.setScale(this.scale);
                    tg.setTransform(trans);
                    localSwitch.addChild((Node)tg);
                    if (this.map.getAlpha(value) > 2) {
                        childMask.set(i);
                    } else {
                        childMask.clear(i);
                    }
                    ++i;
                }
            }
        }
        localSwitch.setChildMask(childMask);
        return globalTG;
    }

    public void updateModel(TransformGroup modelTG) {
        if (this.field == null) {
            return;
        }
        this.extractDimensions();
        Switch localSwitch = (Switch)modelTG.getChild(0);
        BitSet childMask = localSwitch.getChildMask();
        Portrayal p = this.getPortrayalForObject(this.valueToPass);
        if (!(p instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + "for object " + this.valueToPass + " -- expected a SimplePortrayal3D");
        }
        SimplePortrayal3D portrayal = (SimplePortrayal3D)p;
        portrayal.setParentPortrayal(this);
        int i = 0;
        int width = this.width;
        int height = this.height;
        int length = this.length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    double oldValue;
                    TransformGroup tg = (TransformGroup)localSwitch.getChild(i);
                    Shape3D shape = (Shape3D)tg.getChild(0);
                    ValuePortrayal3D.ValueWrapper wrapper = (ValuePortrayal3D.ValueWrapper)shape.getUserData();
                    double value = this.newValue(x, y, z);
                    if (value != (oldValue = wrapper.lastVal)) {
                        if (this.map.getAlpha(value) > 2) {
                            childMask.set(i);
                            wrapper.lastVal = value;
                            portrayal.getModel(wrapper, tg);
                        } else {
                            childMask.clear(i);
                        }
                    }
                    ++i;
                }
            }
        }
        localSwitch.setChildMask(childMask);
    }

    private void extractDimensions() {
        if (this.field instanceof IntGrid3D || this.field instanceof DoubleGrid3D) {
            AbstractGrid3D v = (AbstractGrid3D)this.field;
            this.width = v.getWidth();
            this.height = v.getHeight();
            this.length = v.getLength();
        } else if (this.field instanceof IntGrid2D || this.field instanceof DoubleGrid2D) {
            AbstractGrid2D v = (AbstractGrid2D)this.field;
            this.width = v.getWidth();
            this.height = v.getHeight();
            this.length = 1;
        } else {
            throw new RuntimeException("Invalid field for ValueGridPortrayal3D: " + this.field);
        }
    }

    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        return w;
    }
}

