/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import sim.portrayal3d.network.GenericEdgePortrayal3D;
import sim.portrayal3d.simple.Arrow;
import sim.portrayal3d.simple.PrimitivePortrayal3D;

public class ArrowEdgePortrayal3D
extends GenericEdgePortrayal3D {
    private static Vector3f dummyFrom = new Vector3f(0.0f, -1.0f, 0.0f);
    private static Vector3f dummyTo = new Vector3f(0.0f, 1.0f, 0.0f);

    public ArrowEdgePortrayal3D() {
        this(0.5f);
    }

    public ArrowEdgePortrayal3D(float radius) {
        this(radius, null);
    }

    public ArrowEdgePortrayal3D(float radius, Appearance ap) {
        super((Node)new Arrow(radius, dummyFrom, dummyTo, null, null, ap));
    }

    public ArrowEdgePortrayal3D(Color labelColor) {
        super((Node)new Arrow(1.0f, dummyFrom, dummyTo, null, null, null), labelColor);
    }

    protected int numShapes() {
        return 5;
    }

    protected Shape3D getShape(TransformGroup j3dModel, int shapeIndex) {
        TransformGroup endPointTG = (TransformGroup)j3dModel.getChild(0);
        TransformGroup edgeModelClone = (TransformGroup)endPointTG.getChild(0);
        int coneOffset = 3;
        if (shapeIndex < coneOffset) {
            TransformGroup arrowBody = (TransformGroup)edgeModelClone.getChild(0);
            Cylinder c = (Cylinder)arrowBody.getChild(0);
            return c.getShape(shapeIndex);
        }
        TransformGroup arrowHead = (TransformGroup)edgeModelClone.getChild(1);
        Cone c = (Cone)arrowHead.getChild(0);
        return c.getShape(shapeIndex - coneOffset);
    }

    protected void init(Node edgeModel) {
        super.init(edgeModel);
        Arrow arrow = (Arrow)edgeModel;
        arrow.setCapability(12);
        ((TransformGroup)arrow.getChild(0)).setCapability(12);
        ((TransformGroup)arrow.getChild(1)).setCapability(12);
        Cylinder body = arrow.arrowTail;
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(0));
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(1));
        PrimitivePortrayal3D.setShape3DFlags(body.getShape(2));
        Cone head = arrow.arrowHead;
        PrimitivePortrayal3D.setShape3DFlags(head.getShape(0));
        PrimitivePortrayal3D.setShape3DFlags(head.getShape(1));
    }
}

