/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.network.SimpleEdgePortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.util.Bag;

public class NetworkPortrayal3D
extends FieldPortrayal3D {
    public SpatialNetwork3D field;
    SimpleEdgePortrayal3D defaultPortrayal = new SimpleEdgePortrayal3D();

    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    public void setField(Object field) {
        if (!(field instanceof SpatialNetwork3D)) {
            throw new RuntimeException("Invalid field for FieldPortrayal3D: " + field);
        }
        this.field = (SpatialNetwork3D)field;
    }

    public Object getField() {
        return this.field;
    }

    public TransformGroup createModel() {
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        globalTG.setCapability(13);
        globalTG.setCapability(14);
        if (this.field == null) {
            return globalTG;
        }
        Bag nodes = this.field.network.getAllNodes();
        for (int x = 0; x < nodes.numObjs; ++x) {
            Bag edges = this.field.network.getEdgesOut(nodes.objs[x]);
            for (int y = 0; y < edges.numObjs; ++y) {
                Edge edge = (Edge)edges.objs[y];
                globalTG.addChild((Node)this.wrapModelForNewEdge(edge));
            }
        }
        return globalTG;
    }

    protected BranchGroup wrapModelForNewEdge(Edge edge) {
        SimpleEdgePortrayal3D.EdgeWrapper newinfo = new SimpleEdgePortrayal3D.EdgeWrapper(this, edge);
        Portrayal p = this.getPortrayalForObject(newinfo);
        if (!(p instanceof SimpleEdgePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + edge + " -- expected a SimpleEdgePortrayal3D");
        }
        SimpleEdgePortrayal3D portrayal = (SimpleEdgePortrayal3D)p;
        TransformGroup localTG = portrayal.getModel(newinfo, null);
        localTG.setCapability(12);
        localTG.setUserData((Object)newinfo);
        BranchGroup localBG = new BranchGroup();
        localBG.setCapability(12);
        localBG.setCapability(17);
        localBG.addChild((Node)localTG);
        localBG.setUserData((Object)newinfo);
        return localBG;
    }

    public void updateModel(TransformGroup globalTG) {
        if (this.field == null) {
            return;
        }
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        Network net = this.field.network;
        Bag nodes = net.getAllNodes();
        for (int n = 0; n < nodes.numObjs; ++n) {
            Bag edges = net.getEdgesOut(nodes.objs[n]);
            for (int i = 0; i < edges.numObjs; ++i) {
                Object edge = edges.objs[i];
                hm.put(edge, edge);
            }
        }
        for (int t = globalTG.numChildren() - 1; t >= 0; --t) {
            BranchGroup localBG = (BranchGroup)globalTG.getChild(t);
            SimpleEdgePortrayal3D.EdgeWrapper infoObj = (SimpleEdgePortrayal3D.EdgeWrapper)localBG.getUserData();
            if (hm.remove(infoObj.edge) != null) {
                TransformGroup localTG = (TransformGroup)localBG.getChild(0);
                Portrayal p = this.getPortrayalForObject(infoObj);
                if (!(p instanceof SimplePortrayal3D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + infoObj + " -- expecting a SimplePortrayal3D");
                }
                SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                TransformGroup localTG2 = p3d.getModel(infoObj, localTG);
                if (localTG == localTG2) continue;
                localTG2.setCapability(18);
                localTG2.setCapability(17);
                localTG2.setUserData((Object)infoObj);
                BranchGroup newlocalBG = new BranchGroup();
                newlocalBG.setCapability(12);
                newlocalBG.setCapability(17);
                newlocalBG.setUserData((Object)infoObj);
                newlocalBG.addChild((Node)localTG2);
                globalTG.setChild((Node)newlocalBG, t);
                continue;
            }
            globalTG.removeChild(t);
        }
        if (!hm.isEmpty()) {
            Iterator newObjs = hm.values().iterator();
            while (newObjs.hasNext()) {
                Edge edge = (Edge)newObjs.next();
                globalTG.addChild((Node)this.wrapModelForNewEdge(edge));
            }
        }
    }

    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        return w;
    }
}

