/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Color;
import java.awt.Font;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import sim.field.network.Edge;
import sim.portrayal.FieldPortrayal;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.util.Bag;
import sim.util.Double3D;
import sim.util.MutableDouble;

public class SimpleEdgePortrayal3D
extends SimplePortrayal3D {
    public Color fromColor;
    public Color toColor;
    public Color labelColor;
    public Font labelFont;
    public boolean showLabels;
    double[] startPoint = new double[3];
    double[] endPoint = new double[3];
    double[] middlePoint = new double[3];

    public void setShowLabels(boolean val) {
        this.showLabels = val;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public SimpleEdgePortrayal3D() {
        this(Color.gray, Color.gray, Color.white);
    }

    public SimpleEdgePortrayal3D(Color edgeColor, Color labelColor) {
        this(edgeColor, edgeColor, labelColor, new Font("SansSerif", 0, 60));
    }

    public SimpleEdgePortrayal3D(Color fromColor, Color toColor, Color labelColor) {
        this(fromColor, toColor, labelColor, new Font("SansSerif", 0, 60));
    }

    public SimpleEdgePortrayal3D(Color fromColor, Color toColor, Color labelColor, Font labelFont) {
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.labelColor = labelColor;
        this.labelFont = labelFont;
    }

    static Transform3D transformForOffset(double x, double y, double z) {
        Transform3D offset = new Transform3D();
        offset.setTranslation(new Vector3d(x, y, z));
        return offset;
    }

    static Transform3D transformForOffset(double[] xyz) {
        Transform3D offset = new Transform3D();
        offset.setTranslation(new Vector3d(xyz));
        return offset;
    }

    static Transform3D transformForOffset(float x, float y, float z) {
        Transform3D offset = new Transform3D();
        offset.setTranslation(new Vector3f(x, y, z));
        return offset;
    }

    public String getLabel(Edge edge) {
        Object obj = edge.info;
        if (obj == null) {
            return "";
        }
        return "" + obj;
    }

    public TransformGroup getModel(Object object, TransformGroup j3dModel) {
        Transform3D trans = null;
        EdgeWrapper drawInfo = (EdgeWrapper)object;
        SpatialNetwork3D field = (SpatialNetwork3D)drawInfo.fieldPortrayal.getField();
        Double3D secondPoint = field.getObjectLocation(drawInfo.edge.to());
        Double3D firstPoint = field.getObjectLocation(drawInfo.edge.from());
        this.startPoint[0] = firstPoint.x;
        this.startPoint[1] = firstPoint.y;
        this.startPoint[2] = firstPoint.z;
        this.endPoint[0] = secondPoint.x;
        this.endPoint[1] = secondPoint.y;
        this.endPoint[2] = secondPoint.z;
        this.middlePoint[0] = (secondPoint.x + firstPoint.x) / 2.0;
        this.middlePoint[1] = (secondPoint.y + firstPoint.y) / 2.0;
        this.middlePoint[2] = (secondPoint.z + firstPoint.z) / 2.0;
        if (this.showLabels) {
            trans = SimpleEdgePortrayal3D.transformForOffset(this.middlePoint);
        }
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(14);
            LineArray lineGeometry1 = new LineArray(2, 1);
            lineGeometry1.setCoordinate(0, this.startPoint);
            lineGeometry1.setCoordinate(1, this.middlePoint);
            lineGeometry1.setCapability(1);
            Shape3D lineShape1 = new Shape3D((Geometry)lineGeometry1, SimplePortrayal3D.appearanceForColor(this.fromColor));
            lineShape1.setCapability(13);
            SimpleEdgePortrayal3D.setPickableFlags(lineShape1);
            lineShape1.setUserData((Object)drawInfo);
            j3dModel.addChild((Node)lineShape1);
            LineArray lineGeometry2 = new LineArray(2, 1);
            lineGeometry2.setCoordinate(0, this.middlePoint);
            lineGeometry2.setCoordinate(1, this.endPoint);
            lineGeometry2.setCapability(1);
            Shape3D lineShape2 = new Shape3D((Geometry)lineGeometry2, SimplePortrayal3D.appearanceForColor(this.toColor));
            lineShape2.setCapability(13);
            SimpleEdgePortrayal3D.setPickableFlags(lineShape2);
            lineShape2.setUserData((Object)drawInfo);
            j3dModel.addChild((Node)lineShape2);
            if (this.showLabels) {
                String str = this.getLabel(drawInfo.edge);
                Text2D text = new Text2D(str, new Color3f(this.labelColor), this.labelFont.getFamily(), this.labelFont.getSize(), this.labelFont.getStyle());
                text.setRectangleScaleFactor(0.0625f);
                OrientedShape3D o3d = new OrientedShape3D(text.getGeometry(), text.getAppearance(), 1, new Point3f(0.0f, 0.0f, 0.0f));
                o3d.setCapability(15);
                o3d.setCapability(13);
                o3d.clearCapabilityIsFrequent(15);
                o3d.clearCapabilityIsFrequent(13);
                TransformGroup o = new TransformGroup();
                o.setCapability(12);
                o.setCapability(17);
                o.setCapability(18);
                o.clearCapabilityIsFrequent(12);
                o.setTransform(trans);
                o.setUserData((Object)str);
                SimpleEdgePortrayal3D.clearPickableFlags((Node)o);
                o.addChild((Node)o3d);
                j3dModel.addChild((Node)o);
                Text2D tempText = new Text2D("", new Color3f(this.labelColor), this.labelFont.getFamily(), this.labelFont.getSize(), this.labelFont.getStyle());
                tempText.setCapability(3);
                tempText.setCapability(2);
            }
        } else {
            Shape3D shape = (Shape3D)j3dModel.getChild(0);
            LineArray geo = (LineArray)shape.getGeometry();
            geo.setCoordinate(0, this.startPoint);
            geo.setCoordinate(1, this.middlePoint);
            shape = (Shape3D)j3dModel.getChild(1);
            geo = (LineArray)shape.getGeometry();
            geo.setCoordinate(0, this.startPoint);
            geo.setCoordinate(1, this.endPoint);
            if (this.showLabels) {
                TransformGroup tg = (TransformGroup)j3dModel.getChild(2);
                String str = this.getLabel(drawInfo.edge);
                if (!tg.getUserData().equals(str)) {
                    Text2D text = new Text2D(str, new Color3f(this.labelColor), this.labelFont.getFamily(), this.labelFont.getSize(), this.labelFont.getStyle());
                    text.setRectangleScaleFactor(0.0625f);
                    OrientedShape3D o3d = (OrientedShape3D)tg.getChild(0);
                    o3d.setGeometry(text.getGeometry());
                    o3d.setAppearance(text.getAppearance());
                    tg.setUserData((Object)str);
                }
                tg.setTransform(trans);
            }
        }
        return j3dModel;
    }

    public String getName(LocationWrapper wrapper) {
        return "Edge: " + super.getName(wrapper);
    }

    public static class EdgeWrapper
    extends LocationWrapper {
        MutableDouble val = null;
        SpatialNetwork3D field;
        public Edge edge;

        public EdgeWrapper(FieldPortrayal fieldPortrayal, Edge edge) {
            super(edge.info, edge, fieldPortrayal);
            this.edge = edge;
            this.field = (SpatialNetwork3D)fieldPortrayal.getField();
        }

        public String getLocationName() {
            Edge edge = (Edge)this.getLocation();
            if (this.field != null && this.field.network != null) {
                Bag b = this.field.network.getEdgesOut(edge.from());
                for (int x = 0; x < b.numObjs; ++x) {
                    if (b.objs[x] != edge) continue;
                    return "" + edge.from() + " --> " + edge.to();
                }
            }
            return "Gone.  Was: " + edge.from() + " --> " + edge.to();
        }
    }
}

