/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import sim.field.SparseField;
import sim.field.continuous.Continuous3D;
import sim.field.grid.SparseGrid3D;
import sim.field.network.Network;
import sim.util.Double3D;

public class SpatialNetwork3D {
    public SparseField field;
    public SparseField field2;
    public Network network;

    public SpatialNetwork3D(Continuous3D field, Network network) {
        this.field = field;
        if (field == null) {
            throw new RuntimeException("Null Continuous3D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public SpatialNetwork3D(SparseGrid3D grid, Network network) {
        this.field = grid;
        if (this.field == null) {
            throw new RuntimeException("Null SparseGrid3D.");
        }
        this.network = network;
        if (network == null) {
            throw new RuntimeException("Null Network.");
        }
    }

    public void setAuxillaryField(Continuous3D f) {
        this.field2 = f;
        if (this.field2 != null && this.field instanceof SparseGrid3D) {
            throw new RuntimeException("The auxillary field of a SpatialNetwork3D should be the same type as the primary field.");
        }
    }

    public void setAuxillaryField(SparseGrid3D f) {
        this.field2 = f;
        if (this.field2 != null && this.field instanceof Continuous3D) {
            throw new RuntimeException("The auxillary field of a SpatialNetwork3D should be the same type as the primary field.");
        }
    }

    public Double3D getObjectLocation(Object node) {
        Double3D loc = null;
        loc = this.field instanceof Continuous3D ? ((Continuous3D)this.field).getObjectLocation(node) : ((SparseGrid3D)this.field).getObjectLocationAsDouble3D(node);
        if (loc == null && this.field2 != null) {
            loc = this.field2 instanceof Continuous3D ? ((Continuous3D)this.field2).getObjectLocation(node) : ((SparseGrid3D)this.field2).getObjectLocationAsDouble3D(node);
        }
        return loc;
    }

    public double getWidth() {
        if (this.field instanceof Continuous3D) {
            return ((Continuous3D)this.field).getWidth();
        }
        return ((SparseGrid3D)this.field).getWidth();
    }

    public double getHeight() {
        if (this.field instanceof Continuous3D) {
            return ((Continuous3D)this.field).getHeight();
        }
        return ((SparseGrid3D)this.field).getHeight();
    }

    public double getLength() {
        if (this.field instanceof Continuous3D) {
            return ((Continuous3D)this.field).getLength();
        }
        return ((SparseGrid3D)this.field).getLength();
    }
}

