/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import sim.display.GUIState;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;

public class CircledPortrayal3D
extends SimplePortrayal3D {
    public static final Appearance DEFAULT_CIRCLED_APPEARANCE = CircledPortrayal3D.appearanceForColor(new Color(255, 255, 255, 63));
    public float scale;
    public Appearance appearance;
    protected SimplePortrayal3D child;
    boolean showCircle = true;
    boolean onlyCircleWhenSelected;

    public CircledPortrayal3D(SimplePortrayal3D child) {
        this(child, 2.0f);
    }

    public CircledPortrayal3D(SimplePortrayal3D child, float scale) {
        this(child, scale, false);
    }

    public CircledPortrayal3D(SimplePortrayal3D child, float scale, boolean onlyCircleWhenSelected) {
        this(child, DEFAULT_CIRCLED_APPEARANCE, scale, onlyCircleWhenSelected);
    }

    public CircledPortrayal3D(SimplePortrayal3D child, Color color) {
        this(child, color, 2.0f, false);
    }

    public CircledPortrayal3D(SimplePortrayal3D child, Color color, float scale, boolean onlyCircleWhenSelected) {
        this(child, CircledPortrayal3D.appearanceForColor(color), scale, onlyCircleWhenSelected);
    }

    public CircledPortrayal3D(SimplePortrayal3D child, Appearance appearance, float scale, boolean onlyCircleWhenSelected) {
        this.child = child;
        this.appearance = appearance;
        this.scale = scale;
        this.onlyCircleWhenSelected = onlyCircleWhenSelected;
    }

    public PolygonAttributes polygonAttributes() {
        return this.child.polygonAttributes();
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.child.getInspector(wrapper, state);
    }

    public String getName(LocationWrapper wrapper) {
        return this.child.getName(wrapper);
    }

    public void setParentPortrayal(FieldPortrayal3D p) {
        this.child.setParentPortrayal(p);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (this.child.setSelected(wrapper, selected)) {
            return super.setSelected(wrapper, selected);
        }
        return false;
    }

    public SimplePortrayal3D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Object provided to CircledPortrayal3D is not a SimplePortrayal3D: " + object);
        }
        return (SimplePortrayal3D)object;
    }

    public void setOnlyCircleWhenSelected(boolean val) {
        this.onlyCircleWhenSelected = val;
    }

    public boolean getOnlyCircleWhenSelected() {
        return this.onlyCircleWhenSelected;
    }

    public boolean isCircleShowing() {
        return this.showCircle;
    }

    public void setCircleShowing(boolean val) {
        this.showCircle = val;
    }

    public void updateSwitch(Switch jswitch, Object object) {
        if (this.showCircle && (this.isSelected(object) || !this.onlyCircleWhenSelected)) {
            jswitch.setWhichChild(-2);
        } else {
            jswitch.setWhichChild(-1);
        }
    }

    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            j3dModel.clearCapabilityIsFrequent(12);
            Switch jswitch = new Switch();
            jswitch.setCapability(18);
            Sphere sphere = new Sphere(this.scale / 2.0f, this.appearance);
            CircledPortrayal3D.clearPickableFlags((Node)sphere);
            TransformGroup n = this.getChild(obj).getModel(obj, null);
            j3dModel.addChild((Node)n);
            jswitch.addChild((Node)sphere);
            j3dModel.addChild((Node)jswitch);
            this.updateSwitch(jswitch, obj);
        } else {
            TransformGroup t = (TransformGroup)j3dModel.getChild(0);
            this.getChild(obj).getModel(obj, t);
            this.updateSwitch((Switch)j3dModel.getChild(1), obj);
        }
        return j3dModel;
    }
}

