/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import java.awt.Color;
import java.awt.Image;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.TexCoord2f;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.SimplePortrayal3D;

public class CubePortrayal3D
extends SimplePortrayal3D {
    public float scale = 1.0f;
    public Appearance appearance;
    public boolean generateNormals;
    public boolean generateTextureCoordinates;
    final float[] scaledVerts = new float[verts.length];
    static final float[] verts = new float[]{0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f};

    public CubePortrayal3D() {
        this(1.0f);
    }

    public CubePortrayal3D(float scale) {
        this(Color.white, scale);
    }

    public CubePortrayal3D(Color color) {
        this(color, 1.0f);
    }

    public CubePortrayal3D(Color color, float scale) {
        this(CubePortrayal3D.appearanceForColor(color), scale);
    }

    public CubePortrayal3D(Appearance appearence) {
        this(appearence, 1.0f);
    }

    public CubePortrayal3D(Appearance appearence, float scale) {
        this(appearence, false, false, scale);
    }

    public CubePortrayal3D(Image image) {
        this(image, 1.0f);
    }

    public CubePortrayal3D(Image image, float scale) {
        this(CubePortrayal3D.appearanceForImage(image, true), false, true, scale);
    }

    public CubePortrayal3D(Appearance appearance, boolean generateNormals, boolean generateTextureCoordinates, float scale) {
        this.generateNormals = generateNormals;
        this.generateTextureCoordinates = generateTextureCoordinates;
        this.appearance = appearance;
        this.scale = scale;
        for (int i = 0; i < this.scaledVerts.length; ++i) {
            this.scaledVerts[i] = verts[i] * scale;
        }
    }

    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            QuadArray quadArray = new QuadArray(24, 1 | (this.generateTextureCoordinates ? 32 : 0));
            quadArray.setCoordinates(0, this.scaledVerts);
            if (this.generateTextureCoordinates) {
                quadArray.setTextureCoordinate(0, 0, new TexCoord2f(1.0f, 1.0f));
                quadArray.setTextureCoordinate(0, 1, new TexCoord2f(1.0f, 0.0f));
                quadArray.setTextureCoordinate(0, 2, new TexCoord2f(0.0f, 0.0f));
                quadArray.setTextureCoordinate(0, 3, new TexCoord2f(0.0f, 1.0f));
            }
            PolygonAttributes pa = new PolygonAttributes();
            pa.setCullFace(1);
            if (!this.appearance.isLive()) {
                this.appearance.setCapability(15);
            }
            this.appearance.setPolygonAttributes(pa);
            Shape3D localShape = new Shape3D((Geometry)quadArray, this.appearance);
            localShape.setCapability(15);
            CubePortrayal3D.setPickableFlags(localShape);
            LocationWrapper pickI = new LocationWrapper(obj, null, this.parentPortrayal);
            localShape.setUserData((Object)pickI);
            j3dModel.addChild((Node)localShape);
        }
        return j3dModel;
    }
}

