/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Color;
import java.awt.Font;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import sim.display.GUIState;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;

public class LabelledPortrayal3D
extends SimplePortrayal3D {
    public static final Transform3D DEFAULT_LABEL_OFFSET = LabelledPortrayal3D.transformForOffset(0.5f, 0.5f, 0.5f);
    public float scale = 1.0f;
    public Color color;
    public Transform3D offset;
    public Font font;
    protected SimplePortrayal3D child;
    public String label;
    boolean showLabel = true;
    boolean onlyLabelWhenSelected;

    static Transform3D transformForOffset(float x, float y, float z) {
        Transform3D offset = new Transform3D();
        offset.setTranslation(new Vector3f(x, y, z));
        return offset;
    }

    public LabelledPortrayal3D(SimplePortrayal3D child, String label) {
        this(child, label, Color.white, false);
    }

    public LabelledPortrayal3D(SimplePortrayal3D child, String label, Color color, boolean onlyLabelWhenSelected) {
        this(child, DEFAULT_LABEL_OFFSET, new Font("SansSerif", 0, 24), label, color, 1.0f, onlyLabelWhenSelected);
    }

    public LabelledPortrayal3D(SimplePortrayal3D child, float offsetx, float offsety, float offsetz, Font font, String label, Color color, float scale, boolean onlyLabelWhenSelected) {
        this(child, LabelledPortrayal3D.transformForOffset(offsetx, offsety, offsetz), font, label, color, scale, onlyLabelWhenSelected);
    }

    public LabelledPortrayal3D(SimplePortrayal3D child, Transform3D offset, Font font, String label, Color color, float scale, boolean onlyLabelWhenSelected) {
        this.child = child;
        this.color = color;
        this.offset = offset;
        this.onlyLabelWhenSelected = onlyLabelWhenSelected;
        this.label = label;
        this.font = font;
        this.scale = scale;
    }

    public PolygonAttributes polygonAttributes() {
        return this.child.polygonAttributes();
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.child.getInspector(wrapper, state);
    }

    public String getName(LocationWrapper wrapper) {
        return this.child.getName(wrapper);
    }

    public void setParentPortrayal(FieldPortrayal3D p) {
        this.child.setParentPortrayal(p);
    }

    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (this.child.setSelected(wrapper, selected)) {
            return super.setSelected(wrapper, selected);
        }
        return false;
    }

    public String getLabel(Object object, TransformGroup j3dModel) {
        if (this.label == null) {
            return "" + object;
        }
        return this.label;
    }

    public void setOnlyLabelWhenSelected(boolean val) {
        this.onlyLabelWhenSelected = val;
    }

    public boolean getOnlyLabelWhenSelected() {
        return this.onlyLabelWhenSelected;
    }

    public boolean isLabelShowing() {
        return this.showLabel;
    }

    public void setLabelShowing(boolean val) {
        this.showLabel = val;
    }

    public SimplePortrayal3D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Object provided to LabelledPortrayal3D is not a SimplePortrayal3D: " + object);
        }
        return (SimplePortrayal3D)object;
    }

    public void updateSwitch(Switch jswitch, Object object) {
        jswitch.setWhichChild(this.showLabel && (this.isSelected(object) || !this.onlyLabelWhenSelected) ? -2 : -1);
    }

    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            TransformGroup n = this.getChild(obj).getModel(obj, null);
            String l = this.getLabel(obj, n);
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            j3dModel.clearCapabilityIsFrequent(12);
            Switch jswitch = new Switch();
            jswitch.setCapability(18);
            jswitch.setCapability(12);
            jswitch.clearCapabilityIsFrequent(18);
            jswitch.clearCapabilityIsFrequent(12);
            jswitch.setUserData((Object)l);
            Text2D text = new Text2D(l, new Color3f(this.color), this.font.getFamily(), this.font.getSize(), this.font.getStyle());
            text.setRectangleScaleFactor(this.scale / 16.0f);
            OrientedShape3D o3d = new OrientedShape3D(text.getGeometry(), text.getAppearance(), 1, new Point3f(0.0f, 0.0f, 0.0f));
            o3d.setCapability(15);
            o3d.setCapability(13);
            o3d.clearCapabilityIsFrequent(15);
            o3d.clearCapabilityIsFrequent(13);
            TransformGroup o = new TransformGroup();
            o.setCapability(12);
            o.clearCapabilityIsFrequent(12);
            o.setTransform(this.offset);
            LabelledPortrayal3D.clearPickableFlags((Node)o);
            o.addChild((Node)o3d);
            jswitch.addChild((Node)o);
            j3dModel.addChild((Node)n);
            j3dModel.addChild((Node)jswitch);
            this.updateSwitch(jswitch, obj);
        } else {
            TransformGroup t = (TransformGroup)j3dModel.getChild(0);
            Switch s = (Switch)j3dModel.getChild(1);
            String l = this.getLabel(obj, t);
            if (!s.getUserData().equals(l) && this.showLabel) {
                Shape3D text = new Shape3D((Geometry)new Text3D(new Font3D(this.font, new FontExtrusion()), l));
                TransformGroup t2 = (TransformGroup)s.getChild(0);
                OrientedShape3D o3d = (OrientedShape3D)t2.getChild(0);
                o3d.setGeometry(text.getGeometry());
                o3d.setAppearance(text.getAppearance());
            }
            this.getChild(obj).getModel(obj, t);
            this.updateSwitch(s, obj);
        }
        return j3dModel;
    }
}

