/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import java.awt.Color;
import java.awt.Image;
import javax.media.j3d.Appearance;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import sim.portrayal3d.simple.PrimitivePortrayal3D;

public class Shape3DPortrayal3D
extends PrimitivePortrayal3D {
    public Shape3DPortrayal3D(Shape3D shape) {
        this(shape, Color.white);
    }

    public Shape3DPortrayal3D(Shape3D shape, Color color) {
        this(shape, Shape3DPortrayal3D.appearanceForColor(color));
    }

    public Shape3DPortrayal3D(Shape3D shape, Image image) {
        this(shape, Shape3DPortrayal3D.appearanceForImage(image, true));
    }

    public Shape3DPortrayal3D(Shape3D shape, Appearance appearance) {
        this.appearance = appearance;
        shape = (Shape3D)shape.cloneTree(true);
        Geometry g = shape.getGeometry();
        if (g instanceof CompressedGeometry) {
            ((CompressedGeometry)g).setCapability(2);
        }
        Shape3DPortrayal3D.setShape3DFlags(shape);
        shape.setAppearance(appearance);
        this.group = shape;
    }

    public Shape3DPortrayal3D(Geometry geometry) {
        this(geometry, Color.white);
    }

    public Shape3DPortrayal3D(Geometry geometry, Color color) {
        this(geometry, Shape3DPortrayal3D.appearanceForColor(color));
    }

    public Shape3DPortrayal3D(Geometry geometry, Image image) {
        this(geometry, Shape3DPortrayal3D.appearanceForImage(image, true));
    }

    public Shape3DPortrayal3D(Geometry geometry, Appearance appearance) {
        this(new Shape3D(geometry), appearance);
    }

    protected int numShapes() {
        return 1;
    }

    protected Shape3D getShape(TransformGroup j3dModel, int shapeNumber) {
        TransformGroup n = j3dModel;
        while (n instanceof TransformGroup) {
            n = n.getChild(0);
        }
        Shape3D p = (Shape3D)n;
        return p;
    }
}

