/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import sim.display.GUIState;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.DoubleGrid3D;
import sim.field.grid.Grid3D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.IntGrid3D;
import sim.portrayal.FieldPortrayal;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimpleInspector;
import sim.portrayal3d.grid.ValueGridPortrayal3D;
import sim.portrayal3d.simple.Shape3DPortrayal3D;
import sim.util.Int2D;
import sim.util.Int3D;
import sim.util.MutableDouble;

public class ValuePortrayal3D
extends Shape3DPortrayal3D {
    public static final int SHAPE_CUBE = 0;
    public static final int SHAPE_SQUARE = 1;
    static final float[] verts_cube = new float[]{0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f};
    static final float[] verts_square = new float[]{0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.0f, -0.5f, 0.5f, 0.0f, -0.5f, -0.5f, 0.0f};
    PolygonAttributes mPolyAttributes = new PolygonAttributes();
    static final Color SEMITRANSPARENT = new Color(64, 64, 64, 64);

    public ValuePortrayal3D() {
        this(0);
    }

    protected boolean setTransform(TransformGroup j3dModel, Transform3D transform) {
        return false;
    }

    protected Shape3D getShape(TransformGroup j3dModel, int shapeNumber) {
        Shape3D p = null;
        if (j3dModel.getChild(0) instanceof TransformGroup) {
            TransformGroup g = (TransformGroup)j3dModel.getChild(0);
            p = (Shape3D)g.getChild(0);
        } else {
            p = (Shape3D)j3dModel.getChild(0);
        }
        return p;
    }

    static GeometryArray processArray(int shape) {
        float[] verts = shape == 0 ? verts_cube : verts_square;
        QuadArray ga = new QuadArray(verts.length / 3, 1);
        ga.setCoordinates(0, verts);
        return ga;
    }

    public ValuePortrayal3D(int shape) {
        super((Geometry)ValuePortrayal3D.processArray(shape), SEMITRANSPARENT);
        this.mPolyAttributes.setCapability(3);
        this.mPolyAttributes.clearCapabilityIsFrequent(3);
        if (shape == 1) {
            this.mPolyAttributes.setCapability(1);
            this.mPolyAttributes.clearCapabilityIsFrequent(1);
        } else {
            this.mPolyAttributes.setCullFace(1);
        }
    }

    public PolygonAttributes polygonAttributes() {
        return this.mPolyAttributes;
    }

    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        float[] c = ((ValueGridPortrayal3D)this.parentPortrayal).map.getColor(((ValueWrapper)obj).lastVal).getRGBComponents(null);
        if (j3dModel == null) {
            j3dModel = super.getModel(obj, j3dModel);
            Appearance app = ValuePortrayal3D.appearanceForColor(((ValueGridPortrayal3D)this.parentPortrayal).map.getColor(((ValueWrapper)obj).lastVal));
            app.setPolygonAttributes(this.polygonAttributes());
            this.setAppearance(j3dModel, app);
            this.getShape(j3dModel, 0).setUserData(obj);
        } else {
            j3dModel = super.getModel(obj, j3dModel);
            Appearance appearance = this.getAppearance(j3dModel);
            appearance.getColoringAttributes().setColor(c[0], c[1], c[2]);
            appearance.getTransparencyAttributes().setTransparency(1.0f - c[3]);
        }
        return j3dModel;
    }

    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        Object field = ((ValueGridPortrayal3D)wrapper.getFieldPortrayal()).getField();
        if (field instanceof DoubleGrid3D || field instanceof DoubleGrid2D) {
            return new SimpleInspector(new DoubleFilter(wrapper), state, "Properties");
        }
        return new SimpleInspector(new IntFilter(wrapper), state, "Properties");
    }

    public String getName(LocationWrapper wrapper) {
        ValueGridPortrayal3D portrayal = (ValueGridPortrayal3D)wrapper.getFieldPortrayal();
        return portrayal.getValueName() + " at " + wrapper.getLocationName();
    }

    public static class IntFilter
    extends Filter {
        public IntFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public int getValue() {
            if (this.grid instanceof IntGrid3D) {
                return ((IntGrid3D)this.grid).field[this.x][this.y][this.z];
            }
            return ((IntGrid2D)((Object)this.grid)).field[this.x][this.y];
        }

        public void setValue(int val) {
            if (this.grid instanceof IntGrid3D) {
                ((IntGrid3D)this.grid).field[this.x][this.y][this.z] = val;
            } else {
                ((IntGrid2D)((Object)this.grid)).field[this.x][this.y] = val;
            }
        }
    }

    public static class DoubleFilter
    extends Filter {
        public DoubleFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public double getValue() {
            if (this.grid instanceof DoubleGrid3D) {
                return ((DoubleGrid3D)this.grid).field[this.x][this.y][this.z];
            }
            return ((DoubleGrid2D)((Object)this.grid)).field[this.x][this.y];
        }

        public void setValue(double val) {
            if (this.grid instanceof DoubleGrid3D) {
                ((DoubleGrid3D)this.grid).field[this.x][this.y][this.z] = val;
            } else {
                ((DoubleGrid2D)((Object)this.grid)).field[this.x][this.y] = val;
            }
        }
    }

    public static abstract class Filter {
        int x;
        int y;
        int z;
        ValueGridPortrayal3D fieldPortrayal;
        Grid3D grid;

        public Filter(LocationWrapper wrapper) {
            this.fieldPortrayal = (ValueGridPortrayal3D)wrapper.getFieldPortrayal();
            this.grid = (Grid3D)this.fieldPortrayal.getField();
            Int3D loc = (Int3D)wrapper.getLocation();
            this.x = loc.x;
            this.y = loc.y;
            this.z = loc.z;
        }
    }

    public static class ValueWrapper
    extends LocationWrapper {
        MutableDouble val = null;
        public double lastVal;

        public ValueWrapper(double lastVal, int x, int y, int z, FieldPortrayal fieldPortrayal) {
            super(null, new Int3D(x, y, z), fieldPortrayal);
            this.lastVal = lastVal;
        }

        public String getLocationName() {
            Int3D loc = (Int3D)this.location;
            Object field = this.fieldPortrayal.getField();
            if (field instanceof DoubleGrid3D || field instanceof IntGrid3D) {
                return loc.toCoordinates();
            }
            return new Int2D(loc.x, loc.y).toCoordinates();
        }

        public Object getObject() {
            Object field = this.fieldPortrayal.getField();
            Int3D loc = (Int3D)this.location;
            if (this.val == null) {
                this.val = new MutableDouble(0.0);
            }
            this.val.val = field instanceof DoubleGrid3D ? ((DoubleGrid3D)field).field[loc.x][loc.y][loc.z] : (field instanceof IntGrid3D ? (double)((IntGrid3D)field).field[loc.x][loc.y][loc.z] : (field instanceof DoubleGrid2D ? ((DoubleGrid2D)field).field[loc.x][loc.y] : (double)((IntGrid2D)field).field[loc.x][loc.y]));
            return this.val;
        }
    }
}

