/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import ec.util.MersenneTwisterFast;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import sim.util.Indexed;

public class Bag
implements Collection,
Serializable,
Cloneable,
Indexed {
    public Object[] objs;
    public int numObjs;

    public Bag() {
        this.numObjs = 0;
        this.objs = new Object[1];
    }

    public Bag(int capacity) {
        this.numObjs = 0;
        this.objs = new Object[capacity];
    }

    public Bag(Bag other) {
        if (other == null) {
            this.numObjs = 0;
            this.objs = new Object[1];
        }
        this.numObjs = other.numObjs;
        this.objs = new Object[this.numObjs];
        System.arraycopy(other.objs, 0, this.objs, 0, this.numObjs);
    }

    public int size() {
        return this.numObjs;
    }

    public boolean isEmpty() {
        return this.numObjs <= 0;
    }

    public boolean addAll(Collection other) {
        if (other instanceof Bag) {
            return this.addAll((Bag)other);
        }
        return this.addAll(this.numObjs, other.toArray());
    }

    public boolean addAll(int index, Collection other) {
        if (other instanceof Bag) {
            return this.addAll(index, (Bag)other);
        }
        return this.addAll(index, other.toArray());
    }

    public boolean addAll(int index, Object[] other) {
        if (index > this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        if (other.length == 0) {
            return false;
        }
        if (this.numObjs + other.length > this.objs.length) {
            this.resize(this.numObjs + other.length);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.length, other.length);
        }
        System.arraycopy(other, 0, this.objs, index, other.length);
        this.numObjs += other.length;
        return true;
    }

    public boolean addAll(Bag other) {
        return this.addAll(this.numObjs, other);
    }

    public boolean addAll(int index, Bag other) {
        if (index > this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        if (other.numObjs <= 0) {
            return false;
        }
        if (this.numObjs + other.numObjs > this.objs.length) {
            this.resize(this.numObjs + other.numObjs);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.numObjs, other.numObjs);
        }
        System.arraycopy(other.objs, 0, this.objs, index, other.numObjs);
        this.numObjs += other.numObjs;
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        Bag b = (Bag)super.clone();
        b.objs = (Object[])this.objs.clone();
        return b;
    }

    public void resize(int toAtLeast) {
        if (this.objs.length >= toAtLeast) {
            return;
        }
        if (this.objs.length * 2 > toAtLeast) {
            toAtLeast = this.objs.length * 2;
        }
        Object[] newobjs = new Object[toAtLeast];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public void shrink(int desiredLength) {
        if (desiredLength < this.numObjs) {
            desiredLength = this.numObjs;
        }
        if (desiredLength >= this.objs.length) {
            return;
        }
        Object[] newobjs = new Object[desiredLength];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public Object top() {
        if (this.numObjs <= 0) {
            return null;
        }
        return this.objs[this.numObjs - 1];
    }

    public Object pop() {
        int numObjs = this.numObjs;
        if (numObjs <= 0) {
            return null;
        }
        Object ret = this.objs[--numObjs];
        this.objs[numObjs] = null;
        this.numObjs = numObjs;
        return ret;
    }

    public boolean push(Object obj) {
        int numObjs = this.numObjs;
        if (numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[numObjs] = obj;
        this.numObjs = numObjs + 1;
        return true;
    }

    public boolean add(Object obj) {
        int numObjs = this.numObjs;
        if (numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[numObjs] = obj;
        this.numObjs = numObjs + 1;
        return true;
    }

    void doubleCapacityPlusOne() {
        Object[] newobjs = new Object[this.numObjs * 2 + 1];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public boolean contains(Object o) {
        int numObjs = this.numObjs;
        Object[] objs = this.objs;
        for (int x = 0; x < numObjs; ++x) {
            if (!(o == null ? objs[x] == null : o == objs[x] || o.equals(objs[x]))) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        if (index >= this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        return this.objs[index];
    }

    public Object getValue(int index) {
        if (index >= this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        return this.objs[index];
    }

    public Object set(int index, Object element) {
        if (index >= this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        Object returnval = this.objs[index];
        this.objs[index] = element;
        return returnval;
    }

    public Object setValue(int index, Object element) {
        if (index >= this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        Object returnval = this.objs[index];
        this.objs[index] = element;
        return returnval;
    }

    public boolean removeAll(Collection c) {
        boolean flag = false;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            flag = true;
        }
        return flag;
    }

    public boolean retainAll(Collection c) {
        boolean flag = false;
        for (int x = 0; x < this.numObjs; ++x) {
            if (c.contains(this.objs[x])) continue;
            flag = true;
            this.remove(x);
            --x;
        }
        return flag;
    }

    public Object removeNondestructively(int index) {
        if (index >= this.numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        Object ret = this.objs[index];
        if (index < this.numObjs - 1) {
            System.arraycopy(this.objs, index + 1, this.objs, index, this.numObjs - index - 1);
        }
        this.objs[this.numObjs - 1] = null;
        --this.numObjs;
        return ret;
    }

    public boolean remove(Object o) {
        int numObjs = this.numObjs;
        Object[] objs = this.objs;
        for (int x = 0; x < numObjs; ++x) {
            if (!(o == null ? objs[x] == null : o == objs[x] || o.equals(objs[x]))) continue;
            this.remove(x);
            return true;
        }
        return false;
    }

    public boolean removeMultiply(Object o) {
        int numObjs = this.numObjs;
        Object[] objs = this.objs;
        boolean flag = false;
        for (int x = 0; x < numObjs; ++x) {
            if (!(o == null ? objs[x] == null : o == objs[x] || o.equals(objs[x]))) continue;
            flag = true;
            this.remove(x);
            --x;
        }
        return flag;
    }

    public Object remove(int index) {
        int _numObjs = this.numObjs;
        if (index >= _numObjs) {
            this.throwIndexOutOfBoundsException(index);
        }
        Object[] _objs = this.objs;
        Object ret = _objs[index];
        _objs[index] = _objs[_numObjs - 1];
        _objs[_numObjs - 1] = null;
        --this.numObjs;
        return ret;
    }

    protected void throwIndexOutOfBoundsException(int index) {
        throw new IndexOutOfBoundsException("" + index);
    }

    public void clear() {
        int len = this.numObjs;
        Object[] o = this.objs;
        for (int i = 0; i < len; ++i) {
            o[i] = null;
        }
        this.numObjs = 0;
    }

    public Object[] toArray() {
        Object[] o = new Object[this.numObjs];
        System.arraycopy(this.objs, 0, o, 0, this.numObjs);
        return o;
    }

    public Object[] toArray(Object[] o) {
        if (o.length < this.numObjs) {
            o = (Object[])Array.newInstance(o.getClass().getComponentType(), this.numObjs);
        }
        System.arraycopy(this.objs, 0, o, 0, this.numObjs);
        if (o.length > this.numObjs) {
            o[this.numObjs] = null;
        }
        return null;
    }

    public Iterator iterator() {
        return new BagIterator(this);
    }

    public Class componentType() {
        return null;
    }

    public void sort(Comparator c) {
        Arrays.sort(this.objs, 0, this.numObjs, c);
    }

    public void fill(Object o) {
        Object[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = 0; x < numObjs; ++x) {
            objs[x] = o;
        }
    }

    public void shuffle(Random random) {
        Object[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            Object obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void shuffle(MersenneTwisterFast random) {
        Object[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            Object obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void reverse() {
        Object[] objs = this.objs;
        int numObjs = this.numObjs;
        int l = numObjs / 2;
        for (int x = 0; x < l; ++x) {
            Object obj = objs[x];
            objs[x] = objs[numObjs - x - 1];
            objs[numObjs - x - 1] = obj;
        }
    }

    static class BagIterator
    implements Iterator,
    Serializable {
        int obj = 0;
        Bag bag;
        boolean canRemove = false;

        public BagIterator(Bag bag) {
            this.bag = bag;
        }

        public boolean hasNext() {
            return this.obj < this.bag.numObjs;
        }

        public Object next() {
            if (this.obj >= this.bag.numObjs) {
                throw new NoSuchElementException("No More Elements");
            }
            this.canRemove = true;
            return this.bag.objs[this.obj++];
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("remove() before next(), or remove() called twice");
            }
            if (this.obj - 1 >= this.bag.numObjs) {
                throw new NoSuchElementException("No More Elements");
            }
            this.bag.removeNondestructively(this.obj - 1);
            --this.obj;
            this.canRemove = false;
        }
    }
}

