/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sim.util.Indexed;
import sim.util.Properties;

public class CollectionProperties
extends Properties {
    Collection collection;
    Map map;
    Indexed indexed;
    boolean isVolatile;

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public CollectionProperties(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Indexed) {
            this.buildCollectionProperties((Indexed)o);
        } else if (o instanceof List) {
            this.buildCollectionProperties((List)o);
        } else if (o instanceof Map) {
            this.buildCollectionProperties((Map)o);
        } else if (o instanceof Collection) {
            this.buildCollectionProperties((Collection)o);
        } else if (o.getClass().isArray()) {
            this.buildCollectionPropertiesForArray(o);
        } else {
            throw new IllegalArgumentException("Invalid type for collection properties: " + o);
        }
        this.object = o;
    }

    void buildCollectionProperties(Collection c) {
        this.isVolatile = true;
        this.collection = c;
        this.object = c;
    }

    void buildCollectionProperties(final List list) {
        this.isVolatile = true;
        this.indexed = new Indexed(){

            public Class componentType() {
                return null;
            }

            public int size() {
                return list.size();
            }

            public Object setValue(int index, Object value) {
                return list.set(index, value);
            }

            public Object getValue(int index) {
                return list.get(index);
            }
        };
        this.object = list;
    }

    void buildCollectionProperties(Map m) {
        this.isVolatile = true;
        this.map = m;
        this.object = m;
    }

    void buildCollectionProperties(Indexed i) {
        this.isVolatile = true;
        this.indexed = i;
        this.object = i;
    }

    void buildCollectionPropertiesForArray(final Object o) {
        this.isVolatile = false;
        this.indexed = new Indexed(){

            public Class componentType() {
                return o.getClass().getComponentType();
            }

            public int size() {
                return Array.getLength(o);
            }

            public Object setValue(int index, Object value) {
                Object oldVal = this.getValue(index);
                Array.set(o, index, value);
                return oldVal;
            }

            public Object getValue(int index) {
                return Array.get(o, index);
            }
        };
        this.object = o;
    }

    public int numProperties() {
        if (this.indexed != null) {
            return this.indexed.size();
        }
        if (this.collection != null) {
            return this.collection.size();
        }
        return this.map.size();
    }

    Iterator valueIterator() {
        if (this.collection != null) {
            return this.collection.iterator();
        }
        Set s = this.map.entrySet();
        final Iterator i = s.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return ((Map.Entry)i.next()).getValue();
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from a CollectionProperties Iterator");
            }
        };
    }

    public Object getValue(int index) {
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        if (this.indexed != null) {
            return this.indexed.getValue(index);
        }
        Iterator i = this.valueIterator();
        Object obj = null;
        for (int x = 0; x <= index; ++x) {
            if (!i.hasNext()) {
                return null;
            }
            obj = i.next();
        }
        return obj;
    }

    public boolean isReadWrite(int index) {
        if (index < 0 || index > this.numProperties()) {
            return false;
        }
        if (this.collection != null) {
            return false;
        }
        Class type = this.getTypeConversion(this.getType(index));
        Object obj = this.getValue(index);
        if (obj != null && !type.isAssignableFrom(obj.getClass())) {
            return false;
        }
        return !this.isComposite(index);
    }

    public String getName(int index) {
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        if (this.map != null) {
            Iterator i = this.map.entrySet().iterator();
            Map.Entry obj = null;
            for (int x = 0; x <= index; ++x) {
                if (!i.hasNext()) {
                    return null;
                }
                obj = i.next();
            }
            return "" + obj.getKey();
        }
        if (this.collection != null) {
            return "Member";
        }
        return "" + index;
    }

    public Class getType(int index) {
        Class type;
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        if (this.indexed != null && (type = this.indexed.componentType()) != null) {
            return type;
        }
        Object obj = this.getValue(index);
        if (obj == null) {
            return Object.class;
        }
        return obj.getClass();
    }

    protected Object _setValue(int index, Object value) {
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        if (this.indexed != null) {
            this.indexed.setValue(index, value);
        } else if (this.map != null) {
            Iterator i = this.map.entrySet().iterator();
            Map.Entry obj = null;
            for (int x = 0; x <= index; ++x) {
                if (!i.hasNext()) {
                    return null;
                }
                obj = i.next();
            }
            this.map.put(((Map.Entry)obj).getKey(), value);
        }
        return this.getValue(index);
    }
}

