/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import sim.util.Int2D;
import sim.util.MutableDouble2D;
import sim.util.MutableInt2D;

public final class Double2D
implements Serializable {
    public final double x;
    public final double y;

    public Double2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Double2D(Int2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(MutableInt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(MutableDouble2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(Point2D.Double p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(Point2D.Float p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Double2D(Point2D p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Double2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public String toString() {
        return "Double2D[" + this.x + "," + this.y + "]";
    }

    public String toCoordinates() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public final int hashCode() {
        double x = this.x;
        double y = this.y;
        if ((double)((int)x) == x && (double)((int)y) == y) {
            int y_ = (int)y;
            int x_ = (int)x;
            y_ += ~(y_ << 15);
            y_ ^= y_ >>> 10;
            y_ += y_ << 3;
            y_ ^= y_ >>> 6;
            y_ += ~(y_ << 11);
            y_ ^= y_ >>> 16;
            return x_ ^ y_;
        }
        long key = Double.doubleToLongBits(y);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        return (int)((key ^= Double.doubleToLongBits(x)) ^ key >> 32);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double2D) {
            Double2D other = (Double2D)obj;
            return Double.doubleToLongBits(other.x) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(other.y) == Double.doubleToLongBits(this.y);
        }
        if (obj instanceof MutableDouble2D) {
            MutableDouble2D other = (MutableDouble2D)obj;
            return Double.doubleToLongBits(other.x) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(other.y) == Double.doubleToLongBits(this.y);
        }
        if (obj instanceof Int2D) {
            Int2D other = (Int2D)obj;
            return (double)other.x == this.x && (double)other.y == this.y;
        }
        if (obj instanceof MutableInt2D) {
            MutableInt2D other = (MutableInt2D)obj;
            return (double)other.x == this.x && (double)other.y == this.y;
        }
        return false;
    }

    public double distance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Double2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Int2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(MutableInt2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Point2D p) {
        double dx = this.x - p.getX();
        double dy = this.y - p.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceSq(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Double2D p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Int2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(MutableInt2D p) {
        double dx = this.x - (double)p.x;
        double dy = this.y - (double)p.y;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Point2D p) {
        double dx = this.x - p.getX();
        double dy = this.y - p.getY();
        return dx * dx + dy * dy;
    }
}

