/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import sim.util.CollectionProperties;
import sim.util.Indexed;
import sim.util.SimpleProperties;

public abstract class Properties
implements Serializable {
    protected Object object;

    public static Properties getProperties(Object object, boolean expandCollections, boolean includeSuperclasses, boolean includeGetClass) {
        return Properties.getProperties(object, expandCollections, includeSuperclasses, includeGetClass, true);
    }

    public static Properties getProperties(Object object, boolean expandCollections, boolean includeSuperclasses, boolean includeGetClass, boolean includeDomains) {
        if (object == null) {
            return new SimpleProperties(object, includeSuperclasses, includeGetClass);
        }
        Class<?> c = object.getClass();
        if (c.isArray()) {
            return new CollectionProperties(object);
        }
        if (expandCollections && (Collection.class.isAssignableFrom(c) || Indexed.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c))) {
            return new CollectionProperties(object);
        }
        return new SimpleProperties(object, includeSuperclasses, includeGetClass, includeDomains);
    }

    public Object getObject() {
        return this.object;
    }

    public abstract boolean isVolatile();

    public abstract int numProperties();

    public abstract Object getValue(int var1);

    public Object getDomain(int index) {
        return null;
    }

    public abstract boolean isReadWrite(int var1);

    public boolean isComposite(int index) {
        if (index < 0 || index > this.numProperties()) {
            return false;
        }
        Class type = this.getTypeConversion(this.getType(index));
        return !type.isPrimitive() && type != String.class;
    }

    public boolean isHidden(int index) {
        return false;
    }

    public abstract String getName(int var1);

    public abstract Class getType(int var1);

    protected abstract Object _setValue(int var1, Object var2);

    public Object setValue(int index, Object value) {
        return this._setValue(index, value);
    }

    public Object setValue(int index, String value) {
        try {
            Class type = this.getType(index);
            if (type == Boolean.TYPE) {
                return this._setValue(index, Boolean.valueOf(value));
            }
            if (type == Byte.TYPE) {
                try {
                    return this._setValue(index, Byte.valueOf(value));
                }
                catch (NumberFormatException e) {
                    double d = Double.parseDouble(value);
                    byte b = (byte)d;
                    if ((double)b == d) {
                        return this._setValue(index, new Byte(b));
                    }
                    throw e;
                }
            }
            if (type == Short.TYPE) {
                try {
                    return this._setValue(index, Short.valueOf(value));
                }
                catch (NumberFormatException e) {
                    double d = Double.parseDouble(value);
                    short b = (short)d;
                    if ((double)b == d) {
                        return this._setValue(index, new Short(b));
                    }
                    throw e;
                }
            }
            if (type == Integer.TYPE) {
                try {
                    return this._setValue(index, Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    double d = Double.parseDouble(value);
                    int b = (int)d;
                    if ((double)b == d) {
                        return this._setValue(index, new Integer(b));
                    }
                    throw e;
                }
            }
            if (type == Long.TYPE) {
                try {
                    return this._setValue(index, Long.valueOf(value));
                }
                catch (NumberFormatException e) {
                    double d = Double.parseDouble(value);
                    long b = (long)d;
                    if ((double)b == d) {
                        return this._setValue(index, new Long(b));
                    }
                    throw e;
                }
            }
            if (type == Float.TYPE) {
                return this._setValue(index, Float.valueOf(value));
            }
            if (type == Double.TYPE) {
                return this._setValue(index, Double.valueOf(value));
            }
            if (type == Character.TYPE) {
                return this._setValue(index, new Character(value.charAt(0)));
            }
            if (type == String.class) {
                return this._setValue(index, value);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Class getTypeConversion(Class type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.TYPE;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.TYPE;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.TYPE;
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.TYPE;
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.TYPE;
        }
        return type;
    }

    public String betterToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            return this.typeToName(c) + "@" + Integer.toHexString(obj.hashCode());
        }
        return "" + obj;
    }

    protected String typeToName(Class type) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            return type.toString();
        }
        if (type == String.class) {
            return "String";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            Class convertedComponentType = this.getTypeConversion(componentType);
            return this.typeToName(convertedComponentType) + "[]";
        }
        return null;
    }
}

