/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import sim.util.Propertied;
import sim.util.Properties;
import sim.util.Proxiable;

public class SimpleProperties
extends Properties
implements Serializable {
    ArrayList getMethods = new ArrayList();
    ArrayList setMethods = new ArrayList();
    ArrayList domMethods = new ArrayList();
    ArrayList hideMethods = new ArrayList();
    Properties auxillary = null;

    public SimpleProperties(Object o) {
        this(o, true, true, true);
    }

    public SimpleProperties(Object o, boolean includeSuperclasses, boolean includeGetClass) {
        this(o, includeSuperclasses, includeGetClass, true);
    }

    public SimpleProperties(Object o, boolean includeSuperclasses, boolean includeGetClass, boolean includeDomains) {
        this.object = o;
        if (o != null && o instanceof Proxiable) {
            this.object = ((Proxiable)o).propertiesProxy();
        } else if (o != null && o instanceof Propertied) {
            this.auxillary = ((Propertied)o).properties();
        }
        this.generateProperties(includeSuperclasses, includeGetClass, includeDomains);
    }

    void generateProperties(boolean includeSuperclasses, boolean includeGetClass, boolean includeDomains) {
        if (this.object != null && this.auxillary == null) {
            try {
                Class<?> c = this.object.getClass();
                Method[] m = includeSuperclasses ? c.getMethods() : c.getDeclaredMethods();
                for (int x = 0; x < m.length; ++x) {
                    Class<?> returnType;
                    if (!m[x].getName().startsWith("get") && !m[x].getName().startsWith("is")) continue;
                    int modifier = m[x].getModifiers();
                    if (!includeGetClass && m[x].getName().equals("getClass") || m[x].getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || (returnType = m[x].getReturnType()) == Void.TYPE) continue;
                    this.getMethods.add(m[x]);
                    this.setMethods.add(this.getWriteProperty(m[x], c));
                    this.domMethods.add(this.getDomain(m[x], c, includeDomains));
                    this.hideMethods.add(this.getHidden(m[x], c));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    Method getHidden(Method m, Class c) {
        try {
            Method m2;
            if (m.getName().startsWith("get")) {
                Method m22 = c.getMethod("hide" + m.getName().substring(3), new Class[0]);
                if (m22.getReturnType() == Boolean.TYPE) {
                    return m22;
                }
            } else if (m.getName().startsWith("is") && (m2 = c.getMethod("hide" + m.getName().substring(2), new Class[0])).getReturnType() == Boolean.TYPE) {
                return m2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    Method getWriteProperty(Method m, Class c) {
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("set" + m.getName().substring(3), m.getReturnType());
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("set" + m.getName().substring(2), m.getReturnType());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    Method getDomain(Method m, Class c, boolean includeDomains) {
        if (!includeDomains) {
            return null;
        }
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("dom" + m.getName().substring(3), new Class[0]);
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("dom" + m.getName().substring(2), new Class[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isVolatile() {
        if (this.auxillary != null) {
            return this.auxillary.isVolatile();
        }
        return false;
    }

    public int numProperties() {
        if (this.auxillary != null) {
            return this.auxillary.numProperties();
        }
        return this.getMethods.size();
    }

    public String getName(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getName(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        if (((Method)this.getMethods.get(index)).getName().startsWith("is")) {
            return ((Method)this.getMethods.get(index)).getName().substring(2);
        }
        return ((Method)this.getMethods.get(index)).getName().substring(3);
    }

    public boolean isReadWrite(int index) {
        if (this.auxillary != null) {
            return this.auxillary.isReadWrite(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return false;
        }
        if (this.isComposite(index)) {
            return false;
        }
        return this.setMethods.get(index) != null;
    }

    public Class getType(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getType(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        Class<?> returnType = ((Method)this.getMethods.get(index)).getReturnType();
        return this.getTypeConversion(returnType);
    }

    public Object getValue(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getValue(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        try {
            return ((Method)this.getMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object _setValue(int index, Object value) {
        if (this.auxillary != null) {
            return this.auxillary.setValue(index, value);
        }
        try {
            if (this.setMethods.get(index) == null) {
                return null;
            }
            ((Method)this.setMethods.get(index)).invoke(this.object, value);
            return this.getValue(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getDomain(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getDomain(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return null;
        }
        try {
            if (this.domMethods.get(index) == null) {
                return null;
            }
            return ((Method)this.domMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isHidden(int index) {
        if (this.auxillary != null) {
            return this.auxillary.isHidden(index);
        }
        if (index < 0 || index > this.numProperties()) {
            return false;
        }
        try {
            if (this.hideMethods.get(index) == null) {
                return false;
            }
            return (Boolean)((Method)this.hideMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

