/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.StringTokenizer;
import sim.util.CharColumnScanner;
import sim.util.FontMetricsScanner;
import sim.util.WordWrapScanner;

public class WordWrap
implements Serializable {
    public static String wrap(String string, int numColumns) {
        return WordWrap.wrap(string, (double)numColumns, new CharColumnScanner());
    }

    public static String wrap(String string, int numPixels, FontMetrics metrics) {
        return WordWrap.wrap(string, (double)numPixels, new FontMetricsScanner(metrics));
    }

    static String wrap(String string, double desiredLength, WordWrapScanner scanner) {
        StringBuffer buf = new StringBuffer(string);
        int s = 0;
        while (s != buf.length()) {
            int l;
            int e = scanner.scan(buf, s, desiredLength) + 1;
            if (e >= buf.length()) {
                return buf.toString();
            }
            char ce = buf.charAt(e);
            if (ce == '\n') {
                s = e + 1;
                continue;
            }
            if (Character.isWhitespace(ce)) {
                int top;
                for (top = e; top < buf.length() - 1 && Character.isWhitespace(buf.charAt(top)) && buf.charAt(top) != '\n'; ++top) {
                }
                buf.delete(e, top);
                if (buf.charAt(e) != '\n') {
                    buf.insert(e, '\n');
                }
                s = e + 1;
                continue;
            }
            for (l = e; l > s && !Character.isWhitespace(buf.charAt(l)); --l) {
            }
            if (l == s && !Character.isWhitespace(buf.charAt(l))) {
                buf.insert(e, '\n');
                s = e + 1;
                continue;
            }
            buf.insert(l + 1, '\n');
            s = l + 2;
        }
        return buf.toString();
    }

    public static String[] split(String str) {
        StringTokenizer tok = new StringTokenizer(str, "\n");
        String[] s = new String[tok.countTokens()];
        int x = 0;
        while (tok.hasMoreTokens()) {
            s[x++] = tok.nextToken();
        }
        return s;
    }

    public static String toHTML(String text) {
        StringBuffer buf = new StringBuffer();
        char[] c = text.toCharArray();
        block5: for (int x = 0; x < c.length; ++x) {
            switch (c[x]) {
                case '\n': 
                case '\r': {
                    buf.append("<br>");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                default: {
                    buf.append(c[x]);
                }
            }
        }
        return buf.toString();
    }
}

