/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class DisclosurePanel
extends JPanel {
    JToggleButton disclosureToggle = new JToggleButton();
    Component abridgedComponent;
    Component disclosedComponent;

    public DisclosurePanel(Component abridgedComponent, Component disclosedComponent) {
        this(abridgedComponent, disclosedComponent, null);
    }

    public DisclosurePanel(Component abridgedComponent, Component disclosedComponent, String borderLabel) {
        this.disclosureToggle.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.disclosureToggle.setContentAreaFilled(false);
        this.disclosureToggle.setFocusPainted(false);
        this.disclosureToggle.setRequestFocusEnabled(false);
        this.disclosureToggle.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.disclosureToggle.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.abridgedComponent = abridgedComponent;
        this.disclosedComponent = disclosedComponent;
        this.setLayout(new BorderLayout());
        Box b = new Box(1);
        b.add(this.disclosureToggle);
        b.add(Box.createGlue());
        this.add((Component)b, "West");
        this.add(abridgedComponent, "Center");
        if (borderLabel != null) {
            this.setBorder(new TitledBorder(borderLabel));
        }
        this.disclosureToggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (DisclosurePanel.this.disclosureToggle.isSelected()) {
                    DisclosurePanel.this.remove(DisclosurePanel.this.abridgedComponent);
                    DisclosurePanel.this.add(DisclosurePanel.this.disclosedComponent, "Center");
                    DisclosurePanel.this.revalidate();
                } else {
                    DisclosurePanel.this.remove(DisclosurePanel.this.disclosedComponent);
                    DisclosurePanel.this.add(DisclosurePanel.this.abridgedComponent, "Center");
                    DisclosurePanel.this.revalidate();
                }
            }
        });
    }

    public void setAbridgedComponent(Component abridgedComponent) {
        if (!this.disclosureToggle.isSelected()) {
            this.remove(this.abridgedComponent);
            this.add(abridgedComponent, "Center");
            this.revalidate();
        }
        this.abridgedComponent = abridgedComponent;
    }

    public void setDisclosedComponent(Component disclosedComponent) {
        if (this.disclosureToggle.isSelected()) {
            this.remove(this.disclosedComponent);
            this.add(disclosedComponent, "Center");
            this.revalidate();
        }
        this.disclosedComponent = disclosedComponent;
    }
}

