/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HTMLBrowser
extends JPanel {
    Stack stack = new Stack();
    JEditorPane infoPane = new JEditorPane();
    JScrollPane scroll;

    public void setText(Object HTMLTextOrURL) {
        if (HTMLTextOrURL == null) {
            HTMLTextOrURL = "<html><body bgcolor='white'></body></html>";
        }
        this.stack = new Stack();
        this.infoPane.setContentType("text/html");
        Document d = this.infoPane.getEditorKit().createDefaultDocument();
        this.infoPane.setDocument(d);
        if (HTMLTextOrURL instanceof String) {
            this.infoPane.setText((String)HTMLTextOrURL);
        } else if (HTMLTextOrURL instanceof URL) {
            try {
                this.infoPane.setPage((URL)HTMLTextOrURL);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.infoPane = new JEditorPane();
            }
        } else {
            new RuntimeException("Info object was neither a string nor a URL").printStackTrace();
            this.infoPane = new JEditorPane();
        }
        this.infoPane.getCaret().setDot(0);
    }

    public HTMLBrowser(final Object HTMLTextOrURL) {
        this.setText(HTMLTextOrURL);
        this.infoPane.setEditable(false);
        this.scroll = new JScrollPane(this.infoPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        this.infoPane.getCaret().setDot(0);
        JButton backButton = new JButton("Back");
        final Box backButtonBox = new Box(0);
        backButtonBox.add(backButton);
        backButtonBox.add(Box.createGlue());
        this.infoPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent he) {
                HyperlinkEvent.EventType type = he.getEventType();
                if (type == HyperlinkEvent.EventType.ENTERED) {
                    HTMLBrowser.this.infoPane.setCursor(Cursor.getPredefinedCursor(12));
                } else if (type == HyperlinkEvent.EventType.EXITED) {
                    HTMLBrowser.this.infoPane.setCursor(Cursor.getDefaultCursor());
                } else {
                    URL url = he.getURL();
                    try {
                        HTMLBrowser.this.infoPane.getEditorKit().createDefaultDocument();
                        HTMLBrowser.this.infoPane.setPage(url);
                        if (HTMLBrowser.this.stack.isEmpty()) {
                            HTMLBrowser.this.add((Component)backButtonBox, "South");
                            HTMLBrowser.this.revalidate();
                        }
                        HTMLBrowser.this.stack.push(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
        backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    HTMLBrowser.this.stack.pop();
                    if (HTMLBrowser.this.stack.isEmpty()) {
                        HTMLBrowser.this.remove(backButtonBox);
                        HTMLBrowser.this.revalidate();
                        HTMLBrowser.this.setText(HTMLTextOrURL);
                    } else {
                        HTMLBrowser.this.infoPane.setPage((URL)HTMLBrowser.this.stack.peek());
                    }
                }
                catch (Exception e) {
                    System.err.println("This should not have happened.");
                    e.printStackTrace();
                }
            }
        });
    }
}

