/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import sim.util.Utilities;
import sim.util.WordWrap;

public class MovieMaker {
    Frame parentForDialogs;
    Object encoder;
    Class encoderClass;
    boolean isRunning;

    public MovieMaker(Frame parent) {
        this.parentForDialogs = parent;
        try {
            this.encoderClass = Class.forName("sim.util.media.MovieEncoder");
        }
        catch (Throwable e) {
            this.encoderClass = null;
        }
    }

    public synchronized boolean start(BufferedImage typicalImage) {
        return this.start(typicalImage, 10.0f);
    }

    public synchronized boolean start(BufferedImage typicalImage, float fps) {
        if (this.isRunning) {
            return false;
        }
        int encodeFormatIndex = 0;
        try {
            Object[] f = (Object[])this.encoderClass.getMethod("getEncodingFormats", Float.TYPE, BufferedImage.class).invoke(null, new Float(fps), typicalImage);
            if (f == null) {
                return false;
            }
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            String[] fmts = new String[f.length];
            String font = p.getFont().getFamily();
            for (int i = 0; i < fmts.length; ++i) {
                fmts[i] = "<html><font face=\"" + font + "\" size=\"-2\">" + WordWrap.toHTML(WordWrap.wrap(f[i].toString(), 40)) + "</font></html>";
            }
            JTextField framerate = new JTextField("" + fps);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(new TitledBorder("Frame Rate"));
            panel.add((Component)framerate, "Center");
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BorderLayout());
            panel2.setBorder(new TitledBorder("Format"));
            JComboBox<String> encoding = new JComboBox<String>(fmts);
            panel2.add(encoding, "Center");
            p.add((Component)panel, "North");
            p.add((Component)panel2, "South");
            if (JOptionPane.showConfirmDialog(this.parentForDialogs, p, "Create a Quicktime Movie...", 2) != 0) {
                return false;
            }
            fps = Float.valueOf(framerate.getText()).floatValue();
            encodeFormatIndex = encoding.getSelectedIndex();
            f = (Object[])this.encoderClass.getMethod("getEncodingFormats", Float.TYPE, BufferedImage.class).invoke(null, new Float(fps), typicalImage);
            FileDialog fd = new FileDialog(this.parentForDialogs, "Stream to Quicktime File...", 1);
            fd.setFile("Untitled.mov");
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return false;
            }
            this.encoder = this.encoderClass.getConstructor(Float.TYPE, File.class, BufferedImage.class, Class.forName("javax.media.Format")).newInstance(new Float(fps), new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".mov")), typicalImage, f[encodeFormatIndex]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this.parentForDialogs, "JMF is not installed on your computer.\nTo create Quicktime movies of your simulation:\n\n1. Download JMF at http://java.sun.com/products/java-media/jmf/\n2. Mac users should download the \"Cross-platform Java\" version\n3. Install the JMF libraries.\n4. Make certain that the jmf.jar file is in your CLASSPATH.\n", "Java Media Framework (JMF) Not Installed", 0, 0, null, options, options[0]);
            this.encoder = null;
            this.isRunning = false;
            return false;
        }
        this.isRunning = true;
        return true;
    }

    public synchronized boolean add(BufferedImage image) {
        if (!this.isRunning) {
            return false;
        }
        try {
            this.encoderClass.getMethod("add", BufferedImage.class).invoke(this.encoder, image);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean stop() {
        boolean success = true;
        if (!this.isRunning) {
            return false;
        }
        try {
            success = (Boolean)this.encoderClass.getMethod("stop", new Class[0]).invoke(this.encoder, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.isRunning = false;
        return success;
    }
}

