/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sim.util.Interval;

public class PropertyField
extends JComponent {
    public JComboBox list = new JComboBox();
    public JTextField valField = new JTextField();
    public JCheckBox checkField = new JCheckBox();
    public JButton viewButton = new JButton("View");
    public JLabel viewLabel = new JLabel();
    public JLabel optionalLabel = new JLabel();
    static final int SLIDER_MAX = 800000;
    static final int SLIDER_WIDTH = 80;
    public JSlider slider = new JSlider(0, 800000){

        public Dimension getMaximumSize() {
            return new Dimension(80, super.getMaximumSize().height);
        }

        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }
    };
    public Border valFieldBorder;
    public Border emptyBorder;
    public String currentValue;
    public boolean isReadWrite;
    public Object domain;
    public int displayState;
    public static final int SHOW_CHECKBOX = 0;
    public static final int SHOW_TEXTFIELD = 1;
    public static final int SHOW_VIEWBUTTON = 2;
    public static final int SHOW_SLIDER = 3;
    public static final int SHOW_LIST = 4;
    public Color defaultColor;
    public Color editedColor = new Color(225, 225, 255);
    boolean edited = false;
    public KeyListener listener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                PropertyField.this.submit();
            } else if (keyEvent.getKeyCode() == 27) {
                PropertyField.this.update();
            } else {
                PropertyField.this.setEdited(true);
            }
        }
    };
    public ActionListener checkListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PropertyField.this.setValue(PropertyField.this.newValue(new Boolean(PropertyField.this.checkField.isSelected()).toString()));
        }
    };
    public ActionListener viewButtonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PropertyField.this.viewProperty();
        }
    };
    public FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            PropertyField.this.submit();
        }
    };
    boolean sliding = false;
    public ChangeListener sliderListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            if (PropertyField.this.domain != null && PropertyField.this.domain instanceof Interval) {
                double d = 0.0;
                Interval domain = (Interval)PropertyField.this.domain;
                int i = PropertyField.this.slider.getValue();
                if (domain.isDouble()) {
                    double min = domain.getMin().doubleValue();
                    double max = domain.getMax().doubleValue();
                    d = (double)i / 800000.0 * (max - min) + min;
                } else {
                    long min = domain.getMin().longValue();
                    long max = domain.getMax().longValue();
                    d = (long)((double)i / 800000.0 * (double)(max - min) + (double)min);
                }
                PropertyField.this.sliding = true;
                PropertyField.this.setValue(PropertyField.this.newValue("" + d));
                PropertyField.this.sliding = false;
            }
        }
    };
    public ActionListener listListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (!PropertyField.this.settingList) {
                PropertyField.this.setValue(PropertyField.this.newValue("" + PropertyField.this.list.getSelectedIndex()));
            }
        }
    };
    boolean settingList = false;

    public void setEditedColor(Color c) {
        this.editedColor = c;
    }

    public Color getEditedColor() {
        return this.editedColor;
    }

    public void submit() {
        if (this.edited) {
            this.setValue(this.newValue(this.valField.getText()));
        }
    }

    public void update() {
        this.setValue(this.getValue());
    }

    void setEdited(boolean edited) {
        this.edited = edited;
        if (edited) {
            this.valField.setBackground(this.editedColor);
        } else {
            this.valField.setBackground(this.isReadWrite ? this.defaultColor : this.checkField.getBackground());
        }
    }

    public void setValue(String val) {
        switch (this.displayState) {
            case 3: {
                this.setEdited(false);
                if (!this.sliding) {
                    this.slide(val);
                }
                this.valField.setText(val);
                break;
            }
            case 1: {
                this.setEdited(false);
                this.valField.setText(val);
                break;
            }
            case 0: {
                if (val != null && val.equals("true")) {
                    this.checkField.setSelected(true);
                    break;
                }
                this.checkField.setSelected(false);
                break;
            }
            case 2: {
                this.viewLabel.setText(val);
                break;
            }
            case 4: {
                this.settingList = true;
                try {
                    this.list.setSelectedIndex(Integer.parseInt(val));
                }
                catch (Exception e) {
                    this.settingList = false;
                    throw new RuntimeException("" + e);
                }
                this.settingList = false;
                break;
            }
        }
        this.currentValue = val;
    }

    void slide(String val) {
        try {
            if (this.domain instanceof Interval) {
                Interval domain = (Interval)this.domain;
                double d = Double.parseDouble(val);
                double min = domain.getMin().doubleValue();
                double max = domain.getMax().doubleValue();
                int i = (int)((d - min) / (max - min) * 800000.0);
                this.slider.setValue(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValue() {
        return this.currentValue;
    }

    public PropertyField() {
        this(null, "", true);
    }

    public PropertyField(String initialValue) {
        this(null, initialValue, true);
    }

    public PropertyField(String initialValue, boolean isReadWrite) {
        this(null, initialValue, isReadWrite);
    }

    public PropertyField(String label, String initialValue) {
        this(label, initialValue, true);
    }

    public PropertyField(String label, String initialValue, boolean isReadWrite) {
        this(label, initialValue, isReadWrite, null, 1);
    }

    public PropertyField(String label, String initialValue, boolean isReadWrite, Object domain, int show) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionalLabel, "West");
        this.valFieldBorder = this.valField.getBorder();
        Insets i = this.valFieldBorder.getBorderInsets(this.valField);
        this.emptyBorder = new EmptyBorder(i.top, i.left, i.bottom, i.right);
        this.defaultColor = this.valField.getBackground();
        this.valField.addKeyListener(this.listener);
        this.valField.addFocusListener(this.focusAdapter);
        this.checkField.addActionListener(this.checkListener);
        this.viewButton.addActionListener(this.viewButtonListener);
        this.slider.addChangeListener(this.sliderListener);
        this.list.addActionListener(this.listListener);
        this.viewButton.putClientProperty("Quaqua.Button.style", "square");
        this.setValues(label, initialValue, isReadWrite, domain, show);
    }

    public void setValues(String label, String initialValue, boolean isReadWrite, Object domain, int show) {
        this.domain = domain;
        this.removeAll();
        this.add((Component)this.optionalLabel, "West");
        if (show == 3 && !isReadWrite) {
            show = 1;
        }
        if (domain != null && domain.getClass().isArray()) {
            domain = Arrays.asList((Object[])domain);
        }
        this.displayState = show;
        switch (this.displayState) {
            case 3: {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)this.valField, "Center");
                if (isReadWrite && domain != null && domain instanceof Interval) {
                    p.add((Component)this.slider, "West");
                }
                this.add((Component)p, "Center");
                break;
            }
            case 1: {
                this.add((Component)this.valField, "Center");
                break;
            }
            case 0: {
                this.add((Component)this.checkField, "Center");
                break;
            }
            case 2: {
                this.add((Component)this.viewLabel, "Center");
                this.add((Component)this.viewButton, "West");
                break;
            }
            case 4: {
                if (domain == null || !(domain instanceof List)) break;
                this.settingList = true;
                this.list.setEditable(false);
                this.list.setModel(new DefaultComboBoxModel<Object>(new Vector<Object>(domain)));
                this.add((Component)this.list, "Center");
                this.list.setEnabled(isReadWrite);
                this.settingList = false;
                break;
            }
        }
        this.revalidate();
        this.repaint();
        this.currentValue = initialValue;
        this.optionalLabel.setText(label);
        this.checkField.setEnabled(isReadWrite);
        this.valField.setEditable(isReadWrite);
        this.valField.setBorder(isReadWrite ? this.valFieldBorder : this.emptyBorder);
        this.isReadWrite = isReadWrite;
        this.setValue(this.currentValue);
    }

    public String newValue(String newValue) {
        return newValue;
    }

    public void viewProperty() {
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.valField.setToolTipText(text);
        this.checkField.setToolTipText(text);
        this.optionalLabel.setToolTipText(text);
        this.viewButton.setToolTipText(text);
        this.viewLabel.setToolTipText(text);
        this.slider.setToolTipText(text);
        this.list.setToolTipText(text);
    }

    public Dimension getMinimumSize() {
        Dimension s = super.getMinimumSize();
        s.height = this.valField.getMinimumSize().height;
        return s;
    }

    public Dimension getPreferredSize() {
        Dimension s = super.getPreferredSize();
        s.height = this.valField.getPreferredSize().height;
        return s;
    }
}

