/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.Color;
import sim.util.Bag;
import sim.util.gui.ColorMap;

public class SimpleColorMap
implements ColorMap {
    public int minRed = 0;
    public int minBlue = 0;
    public int minGreen = 0;
    public int minAlpha = 0;
    public int maxRed = 0;
    public int maxBlue = 0;
    public int maxGreen = 0;
    public int maxAlpha = 0;
    public double maxLevel = 0.0;
    public double minLevel = 0.0;
    public final Color clearColor;
    public Color minColor = this.clearColor = new Color(0, 0, 0, 0);
    public Color maxColor = this.clearColor;
    public static final int COLOR_DISCRETIZATION = 257;
    public Color[] colors;
    Bag[] colorCache = new Bag[257];

    public SimpleColorMap() {
        this.setLevels(0.0, 1.0, Color.black, Color.white);
    }

    public SimpleColorMap(double minLevel, double maxLevel, Color minColor, Color maxColor) {
        this.setLevels(minLevel, maxLevel, minColor, maxColor);
    }

    public SimpleColorMap(Color[] colorTable) {
        this.setColorTable(colorTable);
    }

    public SimpleColorMap(Color[] colorTable, double minLevel, double maxLevel, Color minColor, Color maxColor) {
        this.setColorTable(colorTable);
        this.setLevels(minLevel, maxLevel, minColor, maxColor);
    }

    public void setLevels(double minLevel, double maxLevel, Color minColor, Color maxColor) {
        if (maxLevel < minLevel) {
            throw new RuntimeException("maxLevel cannot be less than minLevel");
        }
        this.minRed = minColor.getRed();
        this.minGreen = minColor.getGreen();
        this.minBlue = minColor.getBlue();
        this.minAlpha = minColor.getAlpha();
        this.maxRed = maxColor.getRed();
        this.maxGreen = maxColor.getGreen();
        this.maxBlue = maxColor.getBlue();
        this.maxAlpha = maxColor.getAlpha();
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
        this.minColor = minColor;
        this.maxColor = maxColor;
        for (int x = 0; x < 257; ++x) {
            this.colorCache[x] = new Bag();
        }
    }

    public Color[] setColorTable(Color[] colorTable) {
        Color[] retval = this.colors;
        this.colors = colorTable;
        return retval;
    }

    public Color getColor(double level) {
        int alpha;
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level];
        }
        if (level > this.maxLevel) {
            level = this.maxLevel;
        } else if (level < this.minLevel) {
            level = this.minLevel;
        }
        if (level == this.minLevel) {
            return this.minColor;
        }
        if (level == this.maxLevel) {
            return this.maxColor;
        }
        double interpolation = (level - this.minLevel) / (this.maxLevel - this.minLevel);
        int n = alpha = this.maxAlpha == this.minAlpha ? this.minAlpha : (int)(interpolation * (double)(this.maxAlpha - this.minAlpha + 1) + (double)this.minAlpha);
        if (alpha == 0) {
            return this.clearColor;
        }
        int red = this.maxRed == this.minRed ? this.minRed : (int)(interpolation * (double)(this.maxRed - this.minRed + 1) + (double)this.minRed);
        int green = this.maxGreen == this.minGreen ? this.minGreen : (int)(interpolation * (double)(this.maxGreen - this.minGreen + 1) + (double)this.minGreen);
        int blue = this.maxBlue == this.minBlue ? this.minBlue : (int)(interpolation * (double)(this.maxBlue - this.minBlue + 1) + (double)this.minBlue);
        int rgb = alpha << 24 | red << 16 | green << 8 | blue;
        Bag colors = this.colorCache[(int)(interpolation * 256.0)];
        for (int x = 0; x < colors.numObjs; ++x) {
            Color c = (Color)colors.objs[x];
            if (c.getRGB() != rgb) continue;
            return c;
        }
        Color c = new Color(rgb, alpha != 0);
        colors.add(c);
        return c;
    }

    public int getAlpha(double level) {
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level].getAlpha();
        }
        if (level > this.maxLevel) {
            level = this.maxLevel;
        } else if (level < this.minLevel) {
            level = this.minLevel;
        }
        if (level == this.minLevel) {
            return this.minColor.getAlpha();
        }
        double interpolation = (level - this.minLevel) / (this.maxLevel - this.minLevel);
        int maxAlpha = this.maxAlpha;
        int minAlpha = this.minAlpha;
        return maxAlpha == minAlpha ? minAlpha : (int)(interpolation * (double)(maxAlpha - minAlpha) + (double)minAlpha);
    }

    public int getRGB(double level) {
        int alpha;
        if (this.colors != null && level >= 0.0 && level < (double)this.colors.length) {
            return this.colors[(int)level].getRGB();
        }
        if (level > this.maxLevel) {
            level = this.maxLevel;
        } else if (level < this.minLevel) {
            level = this.minLevel;
        }
        if (level == this.minLevel) {
            return this.minColor.getRGB();
        }
        double interpolation = (level - this.minLevel) / (this.maxLevel - this.minLevel);
        int maxAlpha = this.maxAlpha;
        int minAlpha = this.minAlpha;
        int n = alpha = maxAlpha == minAlpha ? minAlpha : (int)(interpolation * (double)(maxAlpha - minAlpha) + (double)minAlpha);
        if (alpha == 0) {
            return 0;
        }
        int maxRed = this.maxRed;
        int minRed = this.minRed;
        int maxGreen = this.maxGreen;
        int minGreen = this.minGreen;
        int maxBlue = this.maxBlue;
        int minBlue = this.minBlue;
        int red = maxRed == minRed ? minRed : (int)(interpolation * (double)(maxRed - minRed) + (double)minRed);
        int green = maxGreen == minGreen ? minGreen : (int)(interpolation * (double)(maxGreen - minGreen) + (double)minGreen);
        int blue = maxBlue == minBlue ? minBlue : (int)(interpolation * (double)(maxBlue - minBlue) + (double)minBlue);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public boolean validLevel(double value) {
        if (this.colors != null && value >= 0.0 && value < (double)this.colors.length) {
            return true;
        }
        return value <= this.maxLevel && value >= this.minLevel;
    }

    public double defaultValue() {
        if (this.colors != null) {
            return 0.0;
        }
        return this.minLevel;
    }
}

