/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.ui.RectangleInsets;
import sim.display.GUIState;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.media.chart.SeriesAttributes;

public abstract class ChartGenerator
extends JPanel {
    protected Box globalAttributes = Box.createVerticalBox();
    protected Box seriesAttributes = Box.createVerticalBox();
    protected JFreeChart chart;
    protected ChartPanel chartPanel;
    protected JScrollPane chartHolder = new JScrollPane();
    protected JFrame frame;
    protected PropertyField titleField;
    protected PropertyField xLabel;
    protected PropertyField yLabel;
    protected JCheckBox yLog;
    protected JCheckBox xLog;

    public SeriesAttributes getSeriesAttributes(int seriesIndex) {
        Component[] c = this.seriesAttributes.getComponents();
        return (SeriesAttributes)c[seriesIndex];
    }

    public void setXAxisLogScaled(boolean isLogScaled) {
        this.xLog.setSelected(isLogScaled);
    }

    public boolean isXAxisLogScaled() {
        return this.xLog.isSelected();
    }

    public void setYAxisLogScaled(boolean isLogScaled) {
        this.yLog.setSelected(isLogScaled);
    }

    public boolean isYAxisLogScaled() {
        return this.yLog.isSelected();
    }

    public abstract AbstractSeriesDataset getSeriesDataset();

    public abstract void update();

    public abstract void removeSeries(int var1);

    public abstract void moveSeries(int var1, boolean var2);

    protected abstract void buildChart();

    public void removeAllSeries() {
        for (int x = this.getSeriesDataset().getSeriesCount() - 1; x >= 0; --x) {
            this.removeSeries(x);
        }
    }

    public void quit() {
        this.removeAllSeries();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void addGlobalAttribute(Component component) {
        this.globalAttributes.add(component);
    }

    public Component getGlobalAttribute(int index) {
        return this.globalAttributes.getComponent(index + 2);
    }

    public int getGlobalAttributeCount() {
        return this.globalAttributes.getComponentCount() - 2;
    }

    public Component removeGlobalAttribute(int index) {
        Component component = this.getGlobalAttribute(index);
        this.globalAttributes.remove(index);
        return component;
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
        this.chart.titleChanged(new TitleChangeEvent((Title)new TextTitle(title)));
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
        this.titleField.setValue(title);
    }

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setRangeAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getRangeAxis()));
        this.yLabel.setValue(val);
    }

    public String getRangeAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getRangeAxis().getLabel();
    }

    public void setDomainAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getDomainAxis()));
        this.xLabel.setValue(val);
    }

    public String getDomainAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getDomainAxis().getLabel();
    }

    public ChartGenerator() {
        this.buildChart();
        JSplitPane split = new JSplitPane(1, true);
        split.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane scroll = new JScrollPane();
        JPanel b = new JPanel();
        b.setLayout(new BorderLayout());
        b.add((Component)this.seriesAttributes, "North");
        b.add((Component)new JPanel(), "Center");
        scroll.getViewport().setView(b);
        scroll.setBackground(this.getBackground());
        scroll.getViewport().setBackground(this.getBackground());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        LabelledList list = new LabelledList("Chart");
        this.globalAttributes.add(list);
        JLabel j = new JLabel("Right-Click or Control-Click");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        j = new JLabel("on Chart for More Options");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        this.titleField = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setTitle(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.titleField.setValue(this.chart.getTitle().getText());
        list.add((Component)new JLabel("Title"), (Component)this.titleField);
        this.xLabel = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setDomainAxisLabel(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.xLabel.setValue(this.getDomainAxisLabel());
        list.add((Component)new JLabel("X Label"), (Component)this.xLabel);
        this.yLabel = new PropertyField(){

            public String newValue(String newValue) {
                ChartGenerator.this.setRangeAxisLabel(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.yLabel.setValue(this.getRangeAxisLabel());
        list.add((Component)new JLabel("Y Label"), (Component)this.yLabel);
        this.xLog = new JCheckBox();
        this.xLog.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ChartGenerator.this.xLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(ChartGenerator.this.xLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    ChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)logAxis);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)new NumberAxis(ChartGenerator.this.xLabel.getValue()));
                }
            }
        });
        list.add((Component)new JLabel("Log X axis"), (Component)this.xLog);
        this.yLog = new JCheckBox();
        this.yLog.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ChartGenerator.this.yLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(ChartGenerator.this.yLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    ChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)logAxis);
                } else {
                    ChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)new NumberAxis(ChartGenerator.this.yLabel.getValue()));
                }
            }
        });
        list.add((Component)new JLabel("Log Y axis"), (Component)this.yLog);
        JCheckBox legendCheck = new JCheckBox();
        legendCheck.setSelected(false);
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LegendTitle title = new LegendTitle((LegendItemSource)ChartGenerator.this.chart.getXYPlot());
                    title.setLegendItemGraphicPadding(new RectangleInsets(0.0, 8.0, 0.0, 4.0));
                    ChartGenerator.this.chart.addLegend(title);
                } else {
                    ChartGenerator.this.chart.removeLegend();
                }
            }
        };
        legendCheck.addItemListener(il);
        list.add((Component)new JLabel("Legend"), (Component)legendCheck);
        JCheckBox aliasCheck = new JCheckBox();
        aliasCheck.setSelected(this.chart.getAntiAlias());
        il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ChartGenerator.this.chart.setAntiAlias(e.getStateChange() == 1);
            }
        };
        aliasCheck.addItemListener(il);
        list.add((Component)new JLabel("Antialias"), (Component)aliasCheck);
        JPanel pdfButtonPanel = new JPanel();
        pdfButtonPanel.setLayout(new BorderLayout());
        JButton pdfButton = new JButton("Save as PDF");
        pdfButtonPanel.add((Component)pdfButton, "West");
        pdfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)ChartGenerator.this.frame, "Choose PDF file...", 1);
                fd.setFile(ChartGenerator.this.chart.getTitle().getText() + ".pdf");
                fd.setVisible(true);
                String fileName = fd.getFile();
                if (fileName != null) {
                    Dimension dim = ChartGenerator.this.chartPanel.getPreferredSize();
                    ChartGenerator.this.generatePDF(ChartGenerator.this.chart, dim.width, dim.height, fd.getDirectory() + fileName);
                }
            }
        });
        this.globalAttributes.add(pdfButtonPanel);
        Box outerAttributes = Box.createVerticalBox();
        outerAttributes.add(this.globalAttributes);
        outerAttributes.add(Box.createGlue());
        p.add((Component)outerAttributes, "North");
        p.add((Component)scroll, "Center");
        p.setMinimumSize(new Dimension(0, 0));
        p.setPreferredSize(new Dimension(200, 0));
        split.setLeftComponent(p);
        this.chartHolder.setMinimumSize(new Dimension(0, 0));
        split.setRightComponent(this.chartHolder);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
    }

    public JFrame createFrame(GUIState state) {
        this.frame = new JFrame(){

            public void dispose() {
                ChartGenerator.this.quit();
                super.dispose();
            }
        };
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        });
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.setResizable(true);
        this.frame.pack();
        this.frame.setTitle(this.chart.getTitle().getText());
        return this.frame;
    }

    void generatePDF(JFreeChart chart, int width, int height, String fileName) {
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
            document.addAuthor("MASON");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)rectangle2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            String version = System.getProperty("java.version");
            if (!version.startsWith("1.3")) {
                UIManager.put("ColorChooserUI", Class.forName("ch.randelshofer.quaqua.Quaqua14ColorChooserUI").getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

