/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import sim.util.gui.LabelledList;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.HistogramSeriesAttributes;
import sim.util.media.chart.SeriesAttributes;

public class HistogramGenerator
extends ChartGenerator {
    HistogramDataset dataset;
    ArrayList stoppables = new ArrayList();
    HistogramType histogramType = HistogramType.FREQUENCY;
    ArrayList histogramSeries = new ArrayList();

    public AbstractSeriesDataset getSeriesDataset() {
        return this.dataset;
    }

    public void removeSeries(int index) {
        Object tmpObj = this.stoppables.remove(index);
        if (tmpObj != null && tmpObj instanceof SeriesChangeListener) {
            ((SeriesChangeListener)tmpObj).seriesChanged(new SeriesChangeEvent((Object)this));
        }
        this.histogramSeries.remove(index);
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        this.dataset = new HistogramDataset();
        for (int i = 0; i < this.histogramSeries.size(); ++i) {
            HistogramSeries series = (HistogramSeries)this.histogramSeries.get(i);
            this.dataset.addSeries((Comparable)((Object)series.getName()), series.getValues(), series.getBins());
        }
        xyplot.setDataset((XYDataset)this.dataset);
        this.dataset.setType(this.histogramType);
        this.seriesAttributes.remove(index);
        Component[] c = this.seriesAttributes.getComponents();
        for (int i = 0; i < c.length; ++i) {
            SeriesAttributes csa = (SeriesAttributes)c[i];
            if (i >= index) {
                csa.setSeriesIndex(csa.getSeriesIndex() - 1);
            }
            csa.rebuildGraphicsDefinitions();
        }
        this.revalidate();
    }

    public void moveSeries(int index, boolean up) {
        if (index == 0 && up || index == this.histogramSeries.size() - 1 && !up) {
            return;
        }
        int delta = up ? -1 : 1;
        this.histogramSeries.add(index + delta, this.histogramSeries.remove(index));
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        this.dataset = new HistogramDataset();
        for (int i = 0; i < this.histogramSeries.size(); ++i) {
            HistogramSeries series = (HistogramSeries)this.histogramSeries.get(i);
            this.dataset.addSeries((Comparable)((Object)series.getName()), series.getValues(), series.getBins());
        }
        xyplot.setDataset((XYDataset)this.dataset);
        this.dataset.setType(this.histogramType);
        Component[] c = this.seriesAttributes.getComponents();
        SeriesAttributes csa = (SeriesAttributes)c[index];
        csa.setSeriesIndex(index + delta);
        csa.rebuildGraphicsDefinitions();
        csa = (SeriesAttributes)c[index + delta];
        csa.setSeriesIndex(index);
        csa.rebuildGraphicsDefinitions();
        this.seriesAttributes.remove(index + delta);
        this.seriesAttributes.add((Component)csa, index);
        this.revalidate();
        this.stoppables.add(index + delta, this.stoppables.remove(index));
    }

    protected void buildChart() {
        this.dataset = new HistogramDataset();
        this.dataset.setType(HistogramType.FREQUENCY);
        this.chart = ChartFactory.createHistogram((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setPreferredSize(new Dimension(640, 480));
        this.chartPanel.setMinimumDrawHeight(10);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.chartPanel.setMinimumDrawWidth(20);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartHolder.getViewport().setView((Component)this.chartPanel);
    }

    protected void addSeriesToDataSet(HistogramSeries series) {
        this.dataset.addSeries((Comparable)((Object)series.getName()), series.getValues(), series.getBins());
    }

    public void update() {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        this.dataset = new HistogramDataset();
        for (int i = 0; i < this.histogramSeries.size(); ++i) {
            HistogramSeries series = (HistogramSeries)this.histogramSeries.get(i);
            this.addSeriesToDataSet(series);
        }
        xyplot.setDataset((XYDataset)this.dataset);
        this.dataset.setType(this.histogramType);
        Component[] c = this.seriesAttributes.getComponents();
        for (int i = 0; i < c.length; ++i) {
            SeriesAttributes csa = (SeriesAttributes)c[i];
            csa.rebuildGraphicsDefinitions();
        }
        this.revalidate();
    }

    public HistogramGenerator() {
        LabelledList list = new LabelledList("Show Histograms...");
        final HistogramType[] styles = new HistogramType[]{HistogramType.FREQUENCY, HistogramType.RELATIVE_FREQUENCY, HistogramType.SCALE_AREA_TO_1};
        final JComboBox<String> style = new JComboBox<String>(new String[]{"By Frequency", "By Relative Frequency", "With Area = 1.0"});
        style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HistogramGenerator.this.histogramType = styles[style.getSelectedIndex()];
                HistogramGenerator.this.dataset.setType(HistogramGenerator.this.histogramType);
            }
        });
        list.add(style);
        this.addGlobalAttribute(list);
    }

    void updateName(int index, String name, boolean waitUntilUpdate) {
        ((HistogramSeries)this.histogramSeries.get(index)).setName(name);
        if (!waitUntilUpdate) {
            this.update();
        }
    }

    public HistogramSeriesAttributes addSeries(double[] values, int bins, String name, SeriesChangeListener stopper) {
        int i = this.dataset.getSeriesCount();
        if (values != null) {
            this.dataset.addSeries((Comparable)((Object)name), values, bins);
        }
        this.dataset.setType(this.histogramType);
        this.histogramSeries.add(new HistogramSeries(name, values, bins));
        HistogramSeriesAttributes csa = new HistogramSeriesAttributes(this, name, i, false);
        this.seriesAttributes.add(csa);
        this.stoppables.add(stopper);
        this.revalidate();
        return csa;
    }

    public void updateSeries(int index, double[] vals, boolean waitUntilUpdate) {
        if (this.histogramSeries.size() > index) {
            this.updateSeries(index, vals, ((HistogramSeries)this.histogramSeries.get(index)).getBins(), waitUntilUpdate);
        }
    }

    public void updateSeries(int index, int bins, boolean waitUntilUpdate) {
        if (this.histogramSeries.size() > index) {
            this.updateSeries(index, ((HistogramSeries)this.histogramSeries.get(index)).getValues(), bins, waitUntilUpdate);
        }
    }

    public void updateSeries(int index, double[] vals, int bins, boolean waitUntilUpdate) {
        if (this.histogramSeries.size() > index) {
            HistogramSeries series = (HistogramSeries)this.histogramSeries.get(index);
            series.setValues(vals);
            series.setBins(bins);
            if (!waitUntilUpdate) {
                this.update();
            }
        }
    }

    public int getNumBins(int index) {
        return ((HistogramSeries)this.histogramSeries.get(index)).getBins();
    }

    public String getName(int index) {
        return ((HistogramSeries)this.histogramSeries.get(index)).getName();
    }

    public double[] getValues(int index) {
        return ((HistogramSeries)this.histogramSeries.get(index)).getValues();
    }

    public class HistogramSeries {
        double[] values;
        int bins;
        String name;

        public HistogramSeries(String name, double[] values, int bins) {
            this.name = name;
            this.values = values;
            this.bins = bins;
        }

        public void setValues(double[] v) {
            this.values = v;
        }

        public double[] getValues() {
            return this.values;
        }

        public void setBins(int b) {
            this.bins = b;
        }

        public int getBins() {
            return this.bins;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String val) {
            this.name = val;
        }
    }
}

