/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import sim.util.gui.ColorWell;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.HistogramGenerator;
import sim.util.media.chart.SeriesAttributes;

public class HistogramSeriesAttributes
extends SeriesAttributes {
    float thickness;
    NumberTextField thicknessField;
    boolean includeMargin;
    float margin;
    NumberTextField marginField;
    Color fillColor;
    ColorWell fillColorWell;
    Color strokeColor;
    ColorWell strokeColorWell;
    double fillOpacity;
    NumberTextField fillOpacityField;
    double lineOpacity;
    NumberTextField lineOpacityField;
    NumberTextField numBinsField;

    public void setFillOpacity(double value) {
        this.fillOpacityField.setValue(this.fillOpacityField.newValue(value));
    }

    public double getFillOpacity() {
        return this.fillOpacityField.getValue();
    }

    public void setLineOpacity(double value) {
        this.lineOpacityField.setValue(this.lineOpacityField.newValue(value));
    }

    public double getLineOpacity() {
        return this.lineOpacityField.getValue();
    }

    public void setThickness(float value) {
        this.thicknessField.setValue(this.thicknessField.newValue(value));
    }

    public float getThickness() {
        return (float)this.thicknessField.getValue();
    }

    public void setMargin(float value) {
        this.marginField.setValue(this.marginField.newValue(value));
    }

    public float getMargin() {
        return (float)this.marginField.getValue();
    }

    public void setNumBins(int value) {
        this.numBinsField.setValue(this.numBinsField.newValue(value));
    }

    public int getNumBins() {
        return (int)this.numBinsField.getValue();
    }

    public void setFillColor(Color value) {
        this.fillColor = value;
        this.fillColorWell.changeColor(this.fillColor);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setStrokeColor(Color value) {
        this.strokeColor = value;
        this.strokeColorWell.changeColor(this.strokeColor);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public HistogramSeriesAttributes(ChartGenerator generator, String name, int index, boolean includeMargin) {
        super(generator, name, index);
        this.setName(name);
        this.includeMargin = includeMargin;
    }

    public void setSeriesName(String val) {
        this.setName(val);
        ((HistogramGenerator)this.generator).updateName(this.seriesIndex, val, false);
    }

    public String getSeriesName() {
        return this.getName();
    }

    public void rebuildGraphicsDefinitions() {
        XYBarRenderer renderer = (XYBarRenderer)this.getRenderer();
        if ((double)this.thickness == 0.0) {
            renderer.setDrawBarOutline(false);
        } else {
            renderer.setSeriesOutlineStroke(this.getSeriesIndex(), (Stroke)new BasicStroke(this.thickness));
            renderer.setDrawBarOutline(true);
        }
        renderer.setSeriesPaint(this.getSeriesIndex(), (Paint)this.reviseColor(this.fillColor, this.fillOpacity));
        renderer.setSeriesOutlinePaint(this.getSeriesIndex(), (Paint)this.reviseColor(this.strokeColor, this.lineOpacity));
        if (this.includeMargin) {
            renderer.setMargin((double)this.margin);
        }
        this.repaint();
    }

    public void buildAttributes() {
        this.thickness = 2.0f;
        this.margin = 0.5f;
        this.fillOpacity = 1.0;
        this.lineOpacity = 1.0;
        this.numBinsField = new NumberTextField("", (double)((HistogramGenerator)this.generator).getNumBins(this.seriesIndex), true){

            public double newValue(double newValue) {
                if ((newValue = (double)((int)newValue)) < 1.0) {
                    newValue = this.currentValue;
                }
                ((HistogramGenerator)HistogramSeriesAttributes.this.generator).updateSeries(HistogramSeriesAttributes.this.seriesIndex, (int)newValue, false);
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Bins", this.numBinsField);
        this.fillColor = (Color)this.getRenderer().getItemPaint(this.getSeriesIndex(), -1);
        this.fillColor = (Color)this.getRenderer().getSeriesPaint(this.getSeriesIndex());
        this.fillColorWell = new ColorWell(this.fillColor){

            public Color changeColor(Color c) {
                HistogramSeriesAttributes.this.fillColor = c;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Fill", this.fillColorWell);
        this.fillOpacityField = new NumberTextField("Opacity ", this.fillOpacity, 1.0, 0.125){

            public double newValue(double newValue) {
                if (newValue < 0.0 || newValue > 1.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.fillOpacity = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("", this.fillOpacityField);
        this.strokeColor = Color.black;
        this.strokeColorWell = new ColorWell(this.strokeColor){

            public Color changeColor(Color c) {
                HistogramSeriesAttributes.this.strokeColor = c;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Line", this.strokeColorWell);
        this.lineOpacityField = new NumberTextField("Opacity ", this.lineOpacity, 1.0, 0.125){

            public double newValue(double newValue) {
                if (newValue < 0.0 || newValue > 1.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.lineOpacity = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("", this.lineOpacityField);
        this.thicknessField = new NumberTextField((double)this.thickness, false){

            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                HistogramSeriesAttributes.this.thickness = (float)newValue;
                HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Width", this.thicknessField);
        if (this.includeMargin) {
            this.marginField = new NumberTextField(0.5, 1.0, 0.125){

                public double newValue(double newValue) {
                    if (newValue < 0.0 || newValue > 1.0) {
                        newValue = this.currentValue;
                    }
                    HistogramSeriesAttributes.this.margin = (float)newValue;
                    HistogramSeriesAttributes.this.rebuildGraphicsDefinitions();
                    return newValue;
                }
            };
            this.addLabelled("Space", this.marginField);
        }
    }
}

