/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.media.chart.ChartGenerator;

public abstract class SeriesAttributes
extends LabelledList {
    protected int seriesIndex;
    protected ChartGenerator generator;
    public static final ImageIcon I_DOWN = SeriesAttributes.iconFor("DownArrow.png");
    public static final ImageIcon I_DOWN_PRESSED = SeriesAttributes.iconFor("DownArrowPressed.png");
    public static final ImageIcon I_CLOSE = SeriesAttributes.iconFor("CloseBox.png");
    public static final ImageIcon I_CLOSE_PRESSED = SeriesAttributes.iconFor("CloseBoxPressed.png");
    public static final ImageIcon I_UP = SeriesAttributes.iconFor("UpArrow.png");
    public static final ImageIcon I_UP_PRESSED = SeriesAttributes.iconFor("UpArrowPressed.png");
    public Box manipulators;

    public abstract void setSeriesName(String var1);

    public abstract String getSeriesName();

    public abstract void rebuildGraphicsDefinitions();

    public abstract void buildAttributes();

    protected Color reviseColor(Color c, double opacity) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(opacity * 255.0));
    }

    public XYPlot getPlot() {
        return this.generator.getChartPanel().getChart().getXYPlot();
    }

    public ChartGenerator getGenerator() {
        return this.generator;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int val) {
        this.seriesIndex = val;
    }

    protected XYItemRenderer getRenderer() {
        return this.getPlot().getRenderer();
    }

    public static ImageIcon iconFor(String name) {
        return new ImageIcon(SeriesAttributes.class.getResource(name));
    }

    public void setManipulatorsVisible(boolean visible) {
        this.manipulators.setVisible(visible);
    }

    public void buildManipulators() {
        JButton removeButton = new JButton(I_CLOSE);
        removeButton.setPressedIcon(I_CLOSE_PRESSED);
        removeButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        removeButton.setBorderPainted(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showOptionDialog(null, "Remove the Series " + SeriesAttributes.this.getSeriesName() + "?", "Confirm", 0, 3, null, new Object[]{"Remove", "Cancel"}, null) == 0) {
                    SeriesAttributes.this.getGenerator().removeSeries(SeriesAttributes.this.getSeriesIndex());
                }
            }
        });
        JButton upButton = new JButton(I_UP);
        upButton.setPressedIcon(I_UP_PRESSED);
        upButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        upButton.setBorderPainted(false);
        upButton.setContentAreaFilled(false);
        upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.getGenerator().moveSeries(SeriesAttributes.this.getSeriesIndex(), true);
            }
        });
        JButton downButton = new JButton(I_DOWN);
        downButton.setPressedIcon(I_DOWN_PRESSED);
        downButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        downButton.setBorderPainted(false);
        downButton.setContentAreaFilled(false);
        downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.getGenerator().moveSeries(SeriesAttributes.this.getSeriesIndex(), false);
            }
        });
        this.manipulators.add(removeButton);
        this.manipulators.add(upButton);
        this.manipulators.add(downButton);
    }

    public SeriesAttributes(ChartGenerator generator, String name, int index) {
        super(name);
        this.generator = generator;
        this.seriesIndex = index;
        final JCheckBox check = new JCheckBox();
        check.setSelected(true);
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeriesAttributes.this.getRenderer().setSeriesVisible(SeriesAttributes.this.getSeriesIndex(), new Boolean(check.isSelected()));
            }
        });
        this.manipulators = new Box(0);
        this.buildManipulators();
        JLabel spacer = new JLabel("");
        spacer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        Box b = new Box(0);
        b.add(check);
        b.add(spacer);
        b.add(this.manipulators);
        b.add(Box.createGlue());
        this.addLabelled("Show", b);
        PropertyField nameF = new PropertyField(name){

            public String newValue(String newValue) {
                SeriesAttributes.this.setSeriesName(newValue);
                SeriesAttributes.this.getGenerator().getChartPanel().repaint();
                return newValue;
            }
        };
        this.addLabelled("Series", nameF);
        this.buildAttributes();
        this.rebuildGraphicsDefinitions();
    }
}

