/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYSeries;
import sim.util.gui.ColorWell;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.SeriesAttributes;

public class TimeSeriesAttributes
extends SeriesAttributes {
    static final float DASH = 6.0f;
    static final float DOT = 1.0f;
    static final float SPACE = 3.0f;
    static final float SKIP = 6.0f;
    public static final int PATTERN_DASH = 0;
    public static final int PATTERN_DASH_SKIP = 1;
    public static final int PATTERN_DASH_SPACE = 2;
    public static final int PATTERN_DASH_SPACE_DASH_SPACE_DOT_SPACE = 3;
    public static final int PATTERN_DASH_SPACE_DOT_SPACE = 4;
    public static final int PATTERN_DASH_SPACE_DOT_SPACE_DOT_SPACE = 5;
    public static final int PATTERN_DOT_SPACE = 6;
    public static final int PATTERN_DOT_SKIP = 7;
    static final float[][] dashPatterns = new float[][]{{6.0f, 0.0f}, {12.0f, 6.0f}, {6.0f, 6.0f}, {6.0f, 3.0f}, {6.0f, 3.0f, 6.0f, 3.0f, 1.0f, 3.0f}, {6.0f, 3.0f, 1.0f, 3.0f}, {6.0f, 3.0f, 1.0f, 3.0f, 1.0f, 3.0f}, {1.0f, 3.0f}, {1.0f, 6.0f}};
    float stretch;
    NumberTextField stretchField;
    float thickness;
    NumberTextField thicknessField;
    float[] dashPattern;
    JComboBox dashPatternList;
    Color strokeColor;
    ColorWell strokeColorWell;
    public XYSeries series;

    public void setThickness(float value) {
        this.thicknessField.setValue(this.thicknessField.newValue(value));
    }

    public float getThickness() {
        return (float)this.thicknessField.getValue();
    }

    public void setStretch(float value) {
        this.stretchField.setValue(this.stretchField.newValue(value));
    }

    public float getStretch() {
        return (float)this.stretchField.getValue();
    }

    public void setDashPattern(int value) {
        if (value >= 0 && value < dashPatterns.length) {
            this.dashPatternList.setSelectedIndex(value);
            this.dashPattern = dashPatterns[value];
        }
    }

    public float getDashPattern() {
        return this.dashPatternList.getSelectedIndex();
    }

    public void setStrokeColor(Color value) {
        this.strokeColor = value;
        this.strokeColorWell.setColor(this.strokeColor);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setSeriesName(String val) {
        this.series.setKey((Comparable)((Object)val));
    }

    public String getSeriesName() {
        return "" + this.series.getKey();
    }

    public TimeSeriesAttributes(ChartGenerator generator, XYSeries series, int index) {
        super(generator, "" + series.getKey(), index);
        this.series = series;
    }

    public void rebuildGraphicsDefinitions() {
        float[] newDashPattern = new float[this.dashPattern.length];
        for (int x = 0; x < this.dashPattern.length; ++x) {
            if (!(this.stretch * this.thickness > 0.0f)) continue;
            newDashPattern[x] = this.dashPattern[x] * this.stretch * this.thickness;
        }
        XYItemRenderer renderer = this.getRenderer();
        renderer.setSeriesStroke(this.getSeriesIndex(), (Stroke)new BasicStroke(this.thickness, 1, 1, 0.0f, newDashPattern, 0.0f));
        renderer.setSeriesPaint(this.getSeriesIndex(), (Paint)this.strokeColor);
        this.repaint();
    }

    public void buildAttributes() {
        this.dashPattern = dashPatterns[0];
        this.stretch = 1.0f;
        this.thickness = 2.0f;
        XYItemRenderer renderer = this.getRenderer();
        Paint paint = renderer.getItemPaint(this.getSeriesIndex(), -1);
        this.strokeColor = (Color)paint;
        this.strokeColorWell = new ColorWell(this.strokeColor){

            public Color changeColor(Color c) {
                TimeSeriesAttributes.this.strokeColor = c;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return c;
            }
        };
        this.addLabelled("Color", this.strokeColorWell);
        this.thicknessField = new NumberTextField(2.0, true){

            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                TimeSeriesAttributes.this.thickness = (float)newValue;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Width", this.thicknessField);
        this.dashPatternList = new JComboBox();
        this.dashPatternList.setEditable(false);
        this.dashPatternList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList("Solid", "__  __  __", "_  _  _  _", "_ _ _ _ _", "_ _ . _ _ .", "_ . _ . _ .", "_ . . _ . .", ". . . . . . .", ".  .  .  .  ."))));
        this.dashPatternList.setSelectedIndex(0);
        this.dashPatternList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeSeriesAttributes.this.dashPattern = dashPatterns[TimeSeriesAttributes.this.dashPatternList.getSelectedIndex()];
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
            }
        });
        this.addLabelled("Dash", this.dashPatternList);
        this.stretchField = new NumberTextField(1.0, true){

            public double newValue(double newValue) {
                if (newValue < 0.0) {
                    newValue = this.currentValue;
                }
                TimeSeriesAttributes.this.stretch = (float)newValue;
                TimeSeriesAttributes.this.rebuildGraphicsDefinitions();
                return newValue;
            }
        };
        this.addLabelled("Stretch", this.stretchField);
    }
}

