/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sim.util.gui.LabelledList;
import sim.util.gui.NumberTextField;
import sim.util.media.chart.ChartGenerator;
import sim.util.media.chart.DataCuller;
import sim.util.media.chart.MinGapDataCuller;
import sim.util.media.chart.SeriesAttributes;
import sim.util.media.chart.TimeSeriesAttributes;

public class TimeSeriesChartGenerator
extends ChartGenerator {
    protected XYSeriesCollection dataset;
    protected ArrayList stoppables = new ArrayList();
    DatasetChangeEvent updateEvent;
    protected JCheckBox useCullingCheckBox;
    protected NumberTextField maxPointsPerSeriesTextField;
    protected DataCuller dataCuller;

    public AbstractSeriesDataset getSeriesDataset() {
        return this.dataset;
    }

    public void update() {
        if (this.updateEvent == null) {
            this.updateEvent = new DatasetChangeEvent((Object)this.chart.getPlot(), null);
        }
        this.chart.getPlot().datasetChanged(this.updateEvent);
    }

    public void removeSeries(int index) {
        Object tmpObj = this.stoppables.remove(index);
        if (tmpObj != null && tmpObj instanceof SeriesChangeListener) {
            ((SeriesChangeListener)tmpObj).seriesChanged(new SeriesChangeEvent((Object)this));
        }
        this.dataset.removeSeries(index);
        this.seriesAttributes.remove(index);
        Component[] c = this.seriesAttributes.getComponents();
        for (int i = index; i < c.length; ++i) {
            if (i < index) continue;
            SeriesAttributes csa = (SeriesAttributes)c[i];
            csa.setSeriesIndex(csa.getSeriesIndex() - 1);
            csa.rebuildGraphicsDefinitions();
        }
        this.revalidate();
    }

    public void moveSeries(int index, boolean up) {
        List allSeries = this.dataset.getSeries();
        int count = allSeries.size();
        if (index > 0 && up || index < count - 1 && !up) {
            ArrayList items = new ArrayList(allSeries);
            this.dataset.removeAllSeries();
            int delta = up ? -1 : 1;
            items.add(index + delta, items.remove(index));
            for (int i = 0; i < count; ++i) {
                this.dataset.addSeries((XYSeries)items.get(i));
            }
            Component[] c = this.seriesAttributes.getComponents();
            SeriesAttributes csa = (SeriesAttributes)c[index];
            csa.setSeriesIndex(index + delta);
            csa.rebuildGraphicsDefinitions();
            csa = (SeriesAttributes)c[index + delta];
            csa.setSeriesIndex(index);
            csa.rebuildGraphicsDefinitions();
            this.seriesAttributes.remove(index + delta);
            this.seriesAttributes.add((Component)csa, index);
            this.revalidate();
            this.stoppables.add(index + delta, this.stoppables.remove(index));
        }
    }

    protected void buildChart() {
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        ((XYLineAndShapeRenderer)((XYPlot)this.chart.getPlot()).getRenderer()).setDrawSeriesLineAsPath(true);
        this.chart.setAntiAlias(false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setPreferredSize(new Dimension(640, 480));
        this.chartPanel.setMinimumDrawHeight(10);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.chartPanel.setMinimumDrawWidth(20);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartHolder.getViewport().setView((Component)this.chartPanel);
    }

    public TimeSeriesAttributes addSeries(XYSeries series, SeriesChangeListener stopper) {
        int i = this.dataset.getSeriesCount();
        this.dataset.addSeries(series);
        TimeSeriesAttributes csa = new TimeSeriesAttributes((ChartGenerator)this, series, i);
        this.seriesAttributes.add(csa);
        this.stoppables.add(stopper);
        this.revalidate();
        return csa;
    }

    public DataCuller getDataCuller() {
        return this.dataCuller;
    }

    public void setDataCuller(DataCuller dataCuller) {
        this.dataCuller = dataCuller;
    }

    public TimeSeriesChartGenerator() {
        LabelledList globalAttribList = (LabelledList)this.getGlobalAttribute(-2);
        this.useCullingCheckBox = new JCheckBox();
        globalAttribList.add((Component)new JLabel("Cull Data"), (Component)this.useCullingCheckBox);
        this.maxPointsPerSeriesTextField = new NumberTextField(1000.0){

            public double newValue(double val) {
                int max = (int)val;
                if (val < 2.0) {
                    return (int)this.getValue();
                }
                TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(max);
                return max;
            }
        };
        this.useCullingCheckBox.setSelected(true);
        globalAttribList.add((Component)new JLabel("... Over"), (Component)this.maxPointsPerSeriesTextField);
        this.maxPointsPerSeriesTextField.setToolTipText("The maximum number of data points in a series before data culling gets triggered.");
        this.dataCuller = new MinGapDataCuller((int)this.maxPointsPerSeriesTextField.getValue());
        this.useCullingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (TimeSeriesChartGenerator.this.useCullingCheckBox.isSelected()) {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(true);
                    int maxPoints = (int)TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.getValue();
                    TimeSeriesChartGenerator.this.dataCuller = new MinGapDataCuller(maxPoints);
                } else {
                    TimeSeriesChartGenerator.this.maxPointsPerSeriesTextField.setEnabled(false);
                    TimeSeriesChartGenerator.this.dataCuller = null;
                }
            }
        });
    }
}

