/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.dl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.crawl.CatalogCrawler;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.units.TimeUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.StringUtil;

public class ADNWriter {
    private static final Namespace defNS = Namespace.getNamespace((String)"http://adn.dlese.org");
    private static final String schemaLocation = "http://www.dlese.org/Metadata/adn-item/0.6.50/record.xsd";
    private String fileDir;
    private StringBuffer messBuffer;

    public void writeDatasetEntries(InvCatalogImpl cat, String fileDir, StringBuffer mess) {
        this.fileDir = fileDir;
        this.messBuffer = mess;
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        CatalogCrawler.Listener listener = new CatalogCrawler.Listener(){

            @Override
            public void getDataset(InvDataset ds, Object context) {
                ADNWriter.this.doOneDataset(ds);
            }

            @Override
            public boolean getCatalogRef(InvCatalogRef dd, Object context) {
                return true;
            }
        };
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bis);
        CatalogCrawler crawler = new CatalogCrawler(0, true, listener);
        crawler.crawl(cat, null, ps, null);
        mess.append("\n*********************\n");
        mess.append(bis.toString());
    }

    private void doOneDataset(InvDataset ds) {
        if (!ds.isHarvest()) {
            this.messBuffer.append(" Dataset " + ds.getName() + " id = " + ds.getID() + " has harvest = false\n");
        } else if (this.isDatasetUseable(ds, this.messBuffer)) {
            String id = StringUtil.replace((String)ds.getID(), (String)"/", (String)"-");
            String fileOutName = this.fileDir + "/" + id + ".adn.xml";
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
                this.writeOneItem(ds, out);
                ((OutputStream)out).close();
                this.messBuffer.append(" OK on Write\n");
            }
            catch (IOException ioe) {
                this.messBuffer.append("FAILED on Write " + ioe.getMessage() + "\n");
                ioe.printStackTrace();
            }
        }
    }

    public boolean isDatasetUseable(InvDataset ds, StringBuffer sbuff) {
        String rights;
        String summary;
        List<ThreddsMetadata.Source> list;
        boolean ok = true;
        sbuff.append("Dataset " + ds.getName() + " id = " + ds.getID() + ": ");
        if (ds.getName() == null) {
            ok = false;
            sbuff.append(" missing Name field\n");
        }
        if (ds.getUniqueID() == null) {
            ok = false;
            sbuff.append(" missing ID field\n");
        }
        if ((list = ds.getPublishers()) == null || list.size() == 0) {
            ok = false;
            sbuff.append(" must have publisher element that defines the data center\n");
        }
        if ((summary = ds.getDocumentation("summary")) == null) {
            ok = false;
            sbuff.append(" must have documentation element of type summary\n");
        }
        if ((rights = ds.getDocumentation("rights")) == null) {
            ok = false;
            sbuff.append(" must have documentation element of type rights\n");
        }
        sbuff.append(" useable= " + ok + "\n");
        return ok;
    }

    private void writeOneItem(InvDataset ds, OutputStream out) throws IOException {
        Element rootElem = new Element("itemRecord", defNS);
        Document doc = new Document(rootElem);
        this.writeDataset(ds, rootElem);
        rootElem.addNamespaceDeclaration(XMLEntityResolver.xsiNS);
        rootElem.setAttribute("schemaLocation", defNS.getURI() + " " + schemaLocation, XMLEntityResolver.xsiNS);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, out);
    }

    public void writeDataset(InvDataset ds, Element rootElem) {
        DateRange dateRange;
        int pos;
        String href;
        Element generalElem = new Element("general", defNS);
        rootElem.addContent((Content)generalElem);
        generalElem.addContent((Content)new Element("title", defNS).addContent("Dataset " + ds.getFullName()));
        generalElem.addContent((Content)new Element("description", defNS).addContent(ds.getDocumentation("summary")));
        generalElem.addContent((Content)new Element("language", defNS).addContent("en"));
        Element subjects = new Element("subjects", defNS);
        generalElem.addContent((Content)subjects);
        subjects.addContent((Content)new Element("subject", defNS).addContent("DLESE:Atmospheric science"));
        List<Object> list = ds.getKeywords();
        if (list.size() > 0) {
            Element keywords = new Element("keywords", defNS);
            generalElem.addContent((Content)keywords);
            for (int i = 0; i < list.size(); ++i) {
                ThreddsMetadata.Vocab k = list.get(i);
                keywords.addContent((Content)new Element("keyword", defNS).addContent(k.getText()));
            }
        }
        Element lifeElem = new Element("lifecycle", defNS);
        rootElem.addContent((Content)lifeElem);
        if (ds.getPublishers().size() > 0 || ds.getCreators().size() > 0) {
            ThreddsMetadata.Source p;
            int i;
            Element contributors = new Element("contributors", defNS);
            lifeElem.addContent((Content)contributors);
            list = ds.getPublishers();
            for (i = 0; i < list.size(); ++i) {
                p = (ThreddsMetadata.Source)list.get(i);
                if (!p.getNameVocab().getVocabulary().equalsIgnoreCase("ADN")) continue;
                contributors.addContent((Content)this.writeSource(p, "Publisher"));
                break;
            }
            list = ds.getCreators();
            for (i = 0; i < list.size(); ++i) {
                p = (ThreddsMetadata.Source)list.get(i);
                if (!p.getNameVocab().getVocabulary().equalsIgnoreCase("ADN")) continue;
                contributors.addContent((Content)this.writeSource(p, "Author"));
                break;
            }
        }
        Element metaElem = new Element("metaMetadata", defNS);
        rootElem.addContent((Content)metaElem);
        Element entries = new Element("catalogEntries", defNS);
        metaElem.addContent((Content)entries);
        Element entry = new Element("catalog", defNS);
        entries.addContent((Content)entry);
        String id = StringUtil.allow((String)ds.getUniqueID(), (String)".", (char)'-');
        entry.setAttribute("entry", id);
        entry.addContent("THREDDS-motherlode");
        DateType today = new DateType(false, new Date());
        Element dateInfo = new Element("dateInfo", defNS);
        metaElem.addContent((Content)dateInfo);
        dateInfo.setAttribute("created", today.toDateString());
        dateInfo.setAttribute("accessioned", today.toDateString());
        Element status = new Element("statusOf", defNS);
        metaElem.addContent((Content)status);
        status.setAttribute("status", "Accessioned");
        metaElem.addContent((Content)new Element("language", defNS).addContent("en"));
        metaElem.addContent((Content)new Element("scheme", defNS).addContent("ADN (ADEPT/DLESE/NASA Alexandria Digital Earth Prototype/Digital Library for Earth System Education/National Aeronautics and Space Administration)"));
        metaElem.addContent((Content)new Element("copyright", defNS).addContent("Copyright (c) 2002 UCAR (University Corporation for Atmospheric Research)"));
        Element terms = new Element("termsOfUse", defNS);
        metaElem.addContent((Content)terms);
        terms.addContent("Terms of use consistent with DLESE (Digital Library for Earth System Education) policy");
        terms.setAttribute("URI", "http://www.dlese.org/documents/policy/terms_use_full.html");
        Element technical = new Element("technical", defNS);
        rootElem.addContent((Content)technical);
        Element online = new Element("online", defNS);
        technical.addContent((Content)online);
        Element primaryURLelem = new Element("primaryURL", defNS);
        online.addContent((Content)primaryURLelem);
        if (ds instanceof InvCatalogRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            URI uri = catref.getURI();
            href = uri.toString();
            pos = href.lastIndexOf(46);
            href = href.substring(0, pos) + ".html";
        } else {
            InvCatalogImpl cat = (InvCatalogImpl)ds.getParentCatalog();
            String catURL = cat.getBaseURI().toString();
            pos = catURL.lastIndexOf(46);
            String catURLh = catURL.substring(0, pos) + ".html";
            href = catURLh + "?dataset=" + ds.getID();
        }
        primaryURLelem.addContent(href);
        Element mediums = new Element("mediums", defNS);
        online.addContent((Content)mediums);
        mediums.addContent((Content)new Element("medium", defNS).addContent("text/html"));
        Element reqs = new Element("requirements", defNS);
        online.addContent((Content)reqs);
        Element req = new Element("requirement", defNS);
        reqs.addContent((Content)req);
        req.addContent((Content)new Element("reqType", defNS).addContent("DLESE:Other:More specific technical requirements"));
        Element oreqs = new Element("otherRequirements", defNS);
        online.addContent((Content)oreqs);
        Element oreq = new Element("otherRequirement", defNS);
        oreqs.addContent((Content)oreq);
        oreq.addContent((Content)new Element("otherType", defNS).addContent("Requires data viewer tool. See the documentation page in the resource."));
        Element educational = new Element("educational", defNS);
        rootElem.addContent((Content)educational);
        Element audiences = new Element("audiences", defNS);
        educational.addContent((Content)audiences);
        Element audience = new Element("audience", defNS);
        audiences.addContent((Content)audience);
        audience.addContent((Content)new Element("gradeRange", defNS).addContent("DLESE:Graduate or professional"));
        Element resourceTypes = new Element("resourceTypes", defNS);
        educational.addContent((Content)resourceTypes);
        String resourceType = "DLESE:Data:In situ dataset";
        if (ds.getDataType() == FeatureType.GRID) {
            resourceType = "DLESE:Data:Modeled dataset";
        } else if (ds.getDataType() == FeatureType.IMAGE) {
            resourceType = "DLESE:Data:Remotely sensed dataset";
        }
        resourceTypes.addContent((Content)new Element("resourceType", defNS).addContent(resourceType));
        Element rights = new Element("rights", defNS);
        rootElem.addContent((Content)rights);
        rights.addContent((Content)new Element("cost", defNS).addContent("DLESE:No"));
        rights.addContent((Content)new Element("description", defNS).addContent(ds.getDocumentation("rights")));
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        if (null != gc) {
            rootElem.addContent((Content)this.writeGeospatialCoverage(gc));
        }
        if (null != (dateRange = ds.getTimeCoverage())) {
            rootElem.addContent((Content)this.writeTemporalCoverage(dateRange));
        }
    }

    protected boolean emailOK(ThreddsMetadata.Source p) {
        String email = p.getEmail();
        return email.indexOf(64) >= 0;
    }

    protected Element writeSource(ThreddsMetadata.Source p, String role) {
        Element contributor = new Element("contributor", defNS);
        contributor.setAttribute("role", role);
        Element organization = new Element("organization", defNS);
        contributor.addContent((Content)organization);
        String name = p.getNameVocab().getText();
        int pos = name.indexOf(47);
        if (pos > 0) {
            organization.addContent((Content)new Element("instName", defNS).addContent(name.substring(0, pos)));
            organization.addContent((Content)new Element("instDept", defNS).addContent(name.substring(pos + 1)));
        } else {
            organization.addContent((Content)new Element("instName", defNS).addContent(name));
        }
        if (p.getUrl() != null && p.getUrl().length() > 0) {
            organization.addContent((Content)new Element("instUrl", defNS).addContent(p.getUrl()));
        }
        if (this.emailOK(p)) {
            organization.addContent((Content)new Element("instEmail", defNS).addContent(p.getEmail()));
        }
        return contributor;
    }

    protected Element writeGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        Element geos = new Element("geospatialCoverages", defNS);
        Element geo = new Element("geospatialCoverage", defNS);
        geos.addContent((Content)geo);
        Element body = new Element("body", defNS);
        geo.addContent((Content)body);
        body.addContent((Content)new Element("planet", defNS).addContent("Earth"));
        geo.addContent((Content)new Element("geodeticDatumGlobalOrHorz", defNS).addContent("DLESE:WGS84"));
        geo.addContent((Content)new Element("projection", defNS).setAttribute("type", "DLESE:Unknown"));
        geo.addContent((Content)new Element("coordinateSystem", defNS).setAttribute("type", "DLESE:Geographic latitude and longitude"));
        Element bb = new Element("boundBox", defNS);
        geo.addContent((Content)bb);
        double west = LatLonPointImpl.lonNormal((double)gc.getLonWest());
        double east = LatLonPointImpl.lonNormal((double)gc.getLonEast());
        bb.addContent((Content)new Element("westCoord", defNS).setText(ucar.unidata.util.Format.dfrac((double)west, (int)2)));
        bb.addContent((Content)new Element("eastCoord", defNS).setText(ucar.unidata.util.Format.dfrac((double)east, (int)2)));
        bb.addContent((Content)new Element("northCoord", defNS).setText(ucar.unidata.util.Format.dfrac((double)gc.getLatNorth(), (int)2)));
        bb.addContent((Content)new Element("southCoord", defNS).setText(ucar.unidata.util.Format.dfrac((double)gc.getLatSouth(), (int)2)));
        bb.addContent((Content)new Element("bbSrcName", defNS).setText("Calculated from dataset coordinate system by CDM/THREDDS"));
        return geos;
    }

    protected Element writeTemporalCoverage(DateRange dateRange) {
        Element time;
        Element tc = new Element("temporalCoverages", defNS);
        Element tp = new Element("timeAndPeriod", defNS);
        Element ti = new Element("timeInfo", defNS);
        tc.addContent((Content)tp.addContent((Content)ti));
        DateType startDate = dateRange.getStart();
        DateType endDate = dateRange.getEnd();
        if (endDate.isPresent()) {
            String units = "Days ago";
            TimeDuration duration = dateRange.getDuration();
            double value = -0.0;
            try {
                TimeUnit tdayUnit = new TimeUnit("days");
                value = duration.getValue(tdayUnit);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            time = new Element("timeRelative", defNS);
            Element begin = new Element("begin", defNS);
            begin.setAttribute("units", units);
            begin.addContent(Double.toString(value));
            time.addContent((Content)begin);
            Element end = new Element("end", defNS);
            end.setAttribute("units", units);
            end.addContent("0");
            time.addContent((Content)end);
        } else {
            time = new Element("timeAD", defNS);
            Element begin = new Element("begin", defNS);
            begin.setAttribute("date", startDate.toDateString());
            time.addContent((Content)begin);
            Element end = new Element("end", defNS);
            end.setAttribute("date", endDate.toDateString());
            time.addContent((Content)end);
        }
        ti.addContent((Content)time);
        return tc;
    }

    private static void doOne(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            ADNWriter w = new ADNWriter();
            StringBuffer sbuff = new StringBuffer();
            w.writeDatasetEntries(cat, "C:/temp/adn3", sbuff);
            System.out.println(" messages=\n" + sbuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        ADNWriter.doOne(catFactory, "http://motherlode.ucar.edu:9080/thredds/idd/models.xml");
    }
}

