/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.query;

import java.util.ArrayList;
import java.util.List;
import thredds.catalog.InvDocumentation;
import ucar.unidata.util.StringUtil;

public abstract class Selector {
    protected ArrayList children = new ArrayList();
    protected List compound;
    protected boolean isUsed;
    protected String title;
    protected String id;
    protected String template;
    protected boolean required;
    protected boolean multiple;
    protected InvDocumentation desc;

    protected Selector() {
    }

    protected Selector(String title, String id, String template, String required, String multiple) {
        this.title = title;
        this.id = id;
        this.template = template;
        this.required = required == null ? true : !required.equals("false");
        this.multiple = multiple == null ? false : multiple.equals("true");
    }

    public void setDescription(InvDocumentation desc) {
        this.desc = desc;
    }

    public InvDocumentation getDescription() {
        return this.desc;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required == null ? true : !required.equals("false");
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(String multiple) {
        this.multiple = multiple == null ? false : multiple.equals("true");
    }

    public String getSelectType() {
        return this.multiple ? "multiple" : "single";
    }

    public void setCompoundSelectors(List compound) {
        this.compound = compound;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
        if (isUsed && this.compound != null) {
            for (Selector s : this.compound) {
                if (s == this) continue;
                s.setUsed(false);
            }
        }
    }

    public void appendQuery(StringBuffer sbuff, ArrayList values) {
        if (this.template != null) {
            this.appendQueryFromTemplate(sbuff, values);
        } else {
            this.appendQueryFromParamValue(sbuff, values);
        }
    }

    private void appendQueryFromParamValue(StringBuffer sbuff, ArrayList choices) {
        for (int i = 1; i < choices.size(); i += 2) {
            sbuff.append(this.getId());
            sbuff.append("=");
            sbuff.append(choices.get(i).toString());
            sbuff.append("&");
        }
    }

    private void appendQueryFromTemplate(StringBuffer sbuff, ArrayList choices) {
        StringBuffer templateBuff = new StringBuffer(this.template);
        for (int i = 0; i < choices.size(); i += 2) {
            StringUtil.substitute((StringBuffer)templateBuff, (String)choices.get(i).toString(), (String)choices.get(i + 1).toString());
        }
        sbuff.append(templateBuff.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Selector)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (null != this.getId()) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }
}

