/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;

public class StructureMembers {
    private String name;
    private Map<String, Member> memberHash;
    private List<Member> members;
    private int structureSize = -1;

    public StructureMembers(String name) {
        this.name = name;
        this.members = new ArrayList<Member>();
    }

    public StructureMembers(StructureMembers from) {
        this.name = from.name;
        this.members = new ArrayList<Member>(from.getMembers().size());
        for (Member m : from.members) {
            Member nm = new Member(m);
            this.addMember(nm);
            if (m.members == null) continue;
            nm.members = new StructureMembers(m.members);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addMember(Member m) {
        this.members.add(m);
        if (this.memberHash != null) {
            this.memberHash.put(m.getName(), m);
        }
    }

    public Member addMember(String name, String desc, String units, DataType dtype, int[] shape) {
        Member m = new Member(name, desc, units, dtype, shape);
        this.addMember(m);
        return m;
    }

    public void hideMember(Member m) {
        if (m == null) {
            return;
        }
        this.members.remove(m);
    }

    public int getStructureSize() {
        if (this.structureSize < 0) {
            this.calcStructureSize();
        }
        return this.structureSize;
    }

    private void calcStructureSize() {
        this.structureSize = 0;
        for (Member member : this.members) {
            this.structureSize += member.getSizeBytes();
        }
    }

    public void setStructureSize(int structureSize) {
        this.structureSize = structureSize;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Member m : this.members) {
            memberNames.add(m.getName());
        }
        return memberNames;
    }

    public Member getMember(int index) {
        return this.members.get(index);
    }

    public Member findMember(String memberName) {
        if (memberName == null) {
            return null;
        }
        if (this.memberHash == null) {
            int initial_capacity = (int)((double)this.members.size() / 0.75) + 1;
            this.memberHash = new HashMap<String, Member>(initial_capacity);
            for (Member m : this.members) {
                this.memberHash.put(m.getName(), m);
            }
        }
        return this.memberHash.get(memberName);
    }

    public class Member {
        private String name;
        private String desc;
        private String units;
        private DataType dtype;
        private int size = 1;
        private int[] shape;
        private StructureMembers members;
        private Array dataArray;
        private Object dataObject;
        private int dataParam;

        public Member(String name, String desc, String units, DataType dtype, int[] shape) {
            this.name = name;
            this.desc = desc;
            this.units = units;
            this.dtype = dtype;
            this.shape = shape;
            this.size = (int)Index.computeSize(shape);
        }

        public Member(Member from) {
            this.name = from.name;
            this.desc = from.desc;
            this.units = from.units;
            this.dtype = from.dtype;
            this.shape = from.shape;
            this.size = (int)Index.computeSize(this.shape);
            this.members = from.members;
        }

        public void setStructureMembers(StructureMembers members) {
            this.members = members;
        }

        public StructureMembers getStructureMembers() {
            return this.members;
        }

        public void setShape(int[] shape) {
            this.shape = shape;
            this.size = (int)Index.computeSize(shape);
        }

        public String getName() {
            return this.name;
        }

        public String getUnitsString() {
            return this.units;
        }

        public String getDescription() {
            return this.desc;
        }

        public DataType getDataType() {
            return this.dtype;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int getSize() {
            return this.size;
        }

        public int getSizeBytes() {
            if (this.getDataType() == DataType.SEQUENCE) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRING) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRUCTURE) {
                return this.size * this.members.getStructureSize();
            }
            return this.size * this.getDataType().getSize();
        }

        public boolean isScalar() {
            return this.size == 1;
        }

        public int getDataParam() {
            return this.dataParam;
        }

        public void setDataParam(int dataParam) {
            this.dataParam = dataParam;
        }

        public Array getDataArray() {
            return this.dataArray;
        }

        public void setDataArray(Array data) {
            this.dataArray = data;
        }

        public Object getDataObject() {
            return this.dataObject;
        }

        public void setDataObject(Object o) {
            this.dataObject = o;
        }

        public void setVariableInfo(String vname, String desc, String unitString, DataType dtype) {
            if (!this.name.equals(vname) && StructureMembers.this.memberHash != null) {
                StructureMembers.this.memberHash.remove(this.name);
                StructureMembers.this.memberHash.put(vname, this);
            }
            this.name = vname;
            if (dtype != null) {
                this.dtype = dtype;
            }
            if (unitString != null) {
                this.units = unitString;
            }
            if (desc != null) {
                this.desc = desc;
            }
        }

        public void showInternal(Formatter f, String leadingSpace) {
            f.format("%sname='%s' desc='%s' units='%s' dtype=%s size=%d dataObject=%s dataParam=%d", new Object[]{leadingSpace, this.name, this.desc, this.units, this.dtype, this.size, this.dataObject, this.dataParam});
            if (this.members != null) {
                f.format("%n%sNested members %s%n", leadingSpace, this.members.getName());
                for (Member m : this.members.getMembers()) {
                    m.showInternal(f, leadingSpace + "  ");
                }
            }
            f.format("%n", new Object[0]);
        }

        public String toString() {
            return this.name;
        }
    }
}

