/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class NppConvention
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF5")) {
            return false;
        }
        Group loc = ncfile.findGroup("All_Data/VIIRS-MOD-GEO-TC_All");
        if (loc == null) {
            loc = ncfile.findGroup("All_Data/VIIRS-CLD-AGG-GEO_All");
        }
        if (null == loc) {
            return false;
        }
        if (null == loc.findVariable("Latitude")) {
            return false;
        }
        return null != loc.findVariable("Longitude");
    }

    public NppConvention() {
        this.conventionName = "NPP/NPOESS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        ds.addAttribute(null, new Attribute("FeatureType", FeatureType.IMAGE.toString()));
        Group loc = ds.findGroup("All_Data/VIIRS-MOD-GEO-TC_All");
        if (loc == null) {
            loc = ds.findGroup("All_Data/VIIRS-CLD-AGG-GEO_All");
        }
        Variable lat = loc.findVariable("Latitude");
        lat.addAttribute(new Attribute("units", "degrees_north"));
        lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lon = loc.findVariable("Longitude");
        lon.addAttribute(new Attribute("units", "degrees_east"));
        lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int[] shape = lat.getShape();
        assert (shape.length == 2);
        Dimension scan = new Dimension("scan", shape[0]);
        Dimension xscan = new Dimension("xscan", shape[1]);
        loc.addDimension(scan);
        loc.addDimension(xscan);
        lat.setDimensions("scan xscan");
        lon.setDimensions("scan xscan");
        for (Variable v : loc.getVariables()) {
            int[] vs = v.getShape();
            if (vs.length != 2 || vs[0] != shape[0] || vs[1] != shape[1]) continue;
            v.setDimensions("scan xscan");
            v.addAttribute(new Attribute("_CoordinateAxes", "Latitude Longitude"));
        }
        ds.finish();
    }
}

