/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

public class ImageFactoryRandom {
    private List<File> holdList;
    private List<File> fileList;
    private Random random = new Random(System.currentTimeMillis());
    File nextFile = null;

    public ImageFactoryRandom(File topDir) {
        if (!topDir.exists()) {
            return;
        }
        this.fileList = new ArrayList<File>(1000);
        this.addToList(topDir, this.fileList);
        System.out.println("nfiles= " + this.fileList.size());
        this.holdList = new ArrayList<File>(this.fileList);
    }

    private void addToList(File dir, List<File> list) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.addToList(file, list);
                continue;
            }
            if (!file.getName().endsWith(".jpg") && !file.getName().endsWith(".JPG")) continue;
            list.add(file);
        }
    }

    public BufferedImage getNextImage() {
        if (this.holdList.size() == 0) {
            this.holdList = new ArrayList<File>(this.fileList);
        }
        int next = Math.abs(this.random.nextInt()) % this.holdList.size();
        this.nextFile = this.holdList.get(next);
        this.holdList.remove(this.nextFile);
        try {
            System.out.printf("next %d %s %n", next, this.nextFile);
            return ImageIO.read(this.nextFile);
        }
        catch (IOException e) {
            System.out.println("Failed to open image " + this.nextFile);
            this.fileList.remove(this.nextFile);
            return this.getNextImage();
        }
    }

    public void delete() {
        if (this.nextFile == null) {
            return;
        }
        this.fileList.remove(this.nextFile);
        File f = new File("C:/tmp/deleted/" + this.nextFile.getName());
        this.nextFile.renameTo(f);
    }
}

